/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.function.Function;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.client.FLModelLayers;
import me.paulf.fairylights.client.renderer.block.entity.ConnectionRenderer;
import me.paulf.fairylights.server.connection.GarlandVineConnection;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.RandomArray;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public class GarlandVineRenderer
extends ConnectionRenderer<GarlandVineConnection> {
    private static final int RING_COUNT = 7;
    private static final RandomArray RAND = new RandomArray(8411L, 28);
    private final RingsModel rings;

    protected GarlandVineRenderer(Function<ModelLayerLocation, ModelPart> baker) {
        super(baker, FLModelLayers.VINE_WIRE);
        this.rings = new RingsModel(baker.apply(FLModelLayers.GARLAND_RINGS));
    }

    @Override
    protected void render(GarlandVineConnection conn, Curve catenary, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        super.render(conn, catenary, delta, matrix, source, packedLight, packedOverlay);
        int hash = conn.getUUID().hashCode();
        VertexConsumer buf = ClientProxy.SOLID_TEXTURE.m_119194_(source, RenderType::m_110452_);
        catenary.visitPoints(0.25f, false, (index, x, y, z, yaw, pitch) -> {
            matrix.m_85836_();
            matrix.m_85837_((double)x, (double)y, (double)z);
            matrix.m_85845_(Vector3f.f_122225_.m_122270_(-yaw));
            matrix.m_85845_(Vector3f.f_122227_.m_122270_(pitch));
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(RAND.get(index + hash) * 45.0f));
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(RAND.get(index + 8 + hash) * 60.0f + 90.0f));
            this.rings.setWhich(index % 7);
            this.rings.m_7695_(matrix, buf, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrix.m_85849_();
        });
    }

    public static LayerDefinition wireLayer() {
        return ConnectionRenderer.WireModel.createLayer(39, 0, 1);
    }

    public static class RingsModel
    extends Model {
        final ModelPart[] roots;
        int which;

        RingsModel(ModelPart root) {
            super(RenderType::m_110452_);
            ModelPart[] roots = new ModelPart[7];
            for (int i = 0; i < 7; ++i) {
                roots[i] = root.m_171324_(Integer.toString(i));
            }
            this.roots = roots;
        }

        public static LayerDefinition createLayer() {
            float size = 4.0f;
            CubeListBuilder root = CubeListBuilder.m_171558_().m_171514_(14, 91).m_171481_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f);
            PartPose crossPose = PartPose.m_171430_((float)0.0f, (float)0.0f, (float)1.5707964f);
            MeshDefinition mesh = new MeshDefinition();
            for (int i = 0; i < 7; ++i) {
                mesh.m_171576_().m_171599_(Integer.toString(i), root, PartPose.f_171404_).m_171599_("cross_" + i, CubeListBuilder.m_171558_().m_171514_(i * 8, 64).m_171481_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 0.0f).m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 0.0f, 8.0f), crossPose);
            }
            return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
        }

        public void setWhich(int which) {
            this.which = which;
        }

        public void m_7695_(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
            this.roots[this.which].m_104306_(matrix, builder, light, overlay, r, g, b, a);
        }
    }
}

