/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.gui.component;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.paulf.fairylights.client.gui.EditLetteredConnectionScreen;
import me.paulf.fairylights.client.gui.component.ColorButton;
import me.paulf.fairylights.util.FLMth;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.ArrayUtils;

public class PaletteButton
extends Button {
    private static final int TEX_U = 0;
    private static final int TEX_V = 40;
    private static final int SELECT_U = 28;
    private static final int SELECT_V = 40;
    private static final int COLOR_U = 34;
    private static final int COLOR_V = 40;
    private static final int COLOR_WIDTH = 6;
    private static final int COLOR_HEIGHT = 6;
    private static final ChatFormatting[] IDX_COLOR = new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.GRAY, ChatFormatting.DARK_GRAY, ChatFormatting.BLACK, ChatFormatting.RED, ChatFormatting.DARK_RED, ChatFormatting.YELLOW, ChatFormatting.GOLD, ChatFormatting.LIGHT_PURPLE, ChatFormatting.DARK_PURPLE, ChatFormatting.GREEN, ChatFormatting.DARK_GREEN, ChatFormatting.BLUE, ChatFormatting.DARK_BLUE, ChatFormatting.AQUA, ChatFormatting.DARK_AQUA};
    private static final int[] COLOR_IDX = FLMth.invertMap(IDX_COLOR, Enum::ordinal);
    private final ColorButton colorBtn;

    public PaletteButton(int x, int y, ColorButton colorBtn, Component msg, Button.OnPress pressable) {
        super(x, y, 28, 28, msg, pressable);
        this.colorBtn = colorBtn;
    }

    public void m_5691_() {
        this.colorBtn.setDisplayColor(IDX_COLOR[(ArrayUtils.indexOf((Object[])IDX_COLOR, (Object)this.colorBtn.getDisplayColor()) + 1) % IDX_COLOR.length]);
        super.m_5691_();
    }

    public void m_5716_(double mouseX, double mouseY) {
        int idx = this.getMouseOverIndex(mouseX, mouseY);
        if (idx > -1) {
            this.colorBtn.setDisplayColor(IDX_COLOR[idx]);
            super.m_5691_();
        }
    }

    public void m_6303_(PoseStack stack, int mouseX, int mouseY, float delta) {
        if (this.f_93624_) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)EditLetteredConnectionScreen.WIDGETS_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93228_(stack, this.f_93620_, this.f_93621_, 0, 40, this.f_93618_, this.f_93619_);
            if (this.colorBtn.hasDisplayColor()) {
                int idx = COLOR_IDX[this.colorBtn.getDisplayColor().ordinal()];
                int selectX = this.f_93620_ + 2 + idx % 4 * 6;
                int selectY = this.f_93621_ + 2 + idx / 4 * 6;
                this.m_93228_(stack, selectX, selectY, 28, 40, 6, 6);
            }
            for (int i = 0; i < IDX_COLOR.length; ++i) {
                ChatFormatting color = IDX_COLOR[i];
                int rgb = StyledString.getColor(color);
                float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                float b = (float)(rgb & 0xFF) / 255.0f;
                RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
                this.m_93228_(stack, this.f_93620_ + 2 + i % 4 * 6, this.f_93621_ + 2 + i / 4 * 6, 34, 40, 6, 6);
            }
            int selectIndex = this.getMouseOverIndex(mouseX, mouseY);
            if (selectIndex > -1) {
                RenderSystem.m_69478_();
                RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                int hoverSelectX = this.f_93620_ + 2 + selectIndex % 4 * 6;
                int hoverSelectY = this.f_93621_ + 2 + selectIndex / 4 * 6;
                this.m_93228_(stack, hoverSelectX, hoverSelectY, 28, 40, 6, 6);
                RenderSystem.m_69461_();
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private int getMouseOverIndex(double mouseX, double mouseY) {
        int relX = Mth.m_14107_((double)(mouseX - (double)this.f_93620_ - 3.0));
        int relY = Mth.m_14107_((double)(mouseY - (double)this.f_93621_ - 3.0));
        if (relX < 0 || relY < 0 || relX > 22 || relY > 22) {
            return -1;
        }
        int bucketX = relX % 6;
        int bucketY = relY % 6;
        if (bucketX > 3 || bucketY > 3) {
            return -1;
        }
        int x = relX / 6;
        int y = relY / 6;
        return x + y * 4;
    }
}

