/*
 * Decompiled with CFR 0.152.
 */
package net.onvoid.copperized.common.blocks;

import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.onvoid.copperized.common.CopperMaps;
import net.onvoid.copperized.common.CopperizedWeathering;

public class WeatheringCopperDoorBlock
extends DoorBlock
implements CopperizedWeathering {
    private final WeatheringCopper.WeatherState weatherState;

    public WeatheringCopperDoorBlock(WeatheringCopper.WeatherState pWeatherState, BlockBehaviour.Properties properties) {
        super(properties);
        this.weatherState = pWeatherState;
    }

    public void m_7455_(BlockState pState, ServerLevel pLevel, BlockPos pPos, Random pRandom) {
        this.m_153041_(pState, pLevel, pPos, pRandom);
    }

    public boolean m_6724_(BlockState pState) {
        return Optional.ofNullable((Block)CopperMaps.NEXT_BY_BLOCK.get().get((Object)pState.m_60734_())).isPresent();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42784_) {
            Optional<Block> block = CopperMaps.getWaxed(state.m_60734_());
            if (block.isPresent() && state.m_60734_() instanceof WeatheringCopperDoorBlock) {
                BlockPos below = pos.m_7495_();
                BlockPos above = pos.m_7494_();
                BlockState belowState = world.m_8055_(below);
                BlockState aboveState = world.m_8055_(above);
                if (world.m_46749_(above) && aboveState.m_60734_() instanceof WeatheringCopperDoorBlock && ((DoubleBlockHalf)aboveState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.UPPER)) {
                    world.m_7731_(above, block.map(b -> b.m_152465_(aboveState)).get(), 27);
                    world.m_7731_(pos, block.map(b -> b.m_152465_(state)).get(), 27);
                    world.m_5898_(player, 3003, pos, 0);
                    world.m_5898_(player, 3003, above, 0);
                    if (!world.m_5776_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (world.m_46749_(below) && belowState.m_60734_() instanceof WeatheringCopperDoorBlock && ((DoubleBlockHalf)belowState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.LOWER)) {
                    world.m_7731_(pos, block.map(b -> b.m_152465_(state)).get(), 27);
                    world.m_7731_(below, block.map(b -> b.m_152465_(belowState)).get(), 27);
                    world.m_5898_(player, 3003, pos, 0);
                    world.m_5898_(player, 3003, below, 0);
                    if (!world.m_5776_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            world.m_7731_(pos, block.map(b -> b.m_152465_(state)).get(), 11);
            world.m_5898_(player, 3003, pos, 0);
            if (!world.m_5776_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState getToolModifiedState(BlockState state, Level world, BlockPos pos, Player player, ItemStack stack, ToolAction toolAction) {
        Optional<Block> block;
        if (stack.canPerformAction(toolAction) && ToolActions.AXE_SCRAPE.equals(toolAction) && (block = CopperMaps.getPrevious(state.m_60734_())).isPresent() && state.m_60734_() instanceof WeatheringCopperDoorBlock) {
            BlockPos below = pos.m_7495_();
            BlockPos above = pos.m_7494_();
            BlockState belowState = world.m_8055_(below);
            BlockState aboveState = world.m_8055_(above);
            BlockState newState = block.map(b -> b.m_152465_(state)).get();
            if (world.m_46749_(above) && aboveState.m_60734_() instanceof WeatheringCopperDoorBlock && ((DoubleBlockHalf)aboveState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.UPPER)) {
                world.m_7731_(above, block.map(b -> b.m_152465_(aboveState)).get(), 27);
                world.m_5898_(player, 3005, above, 0);
                return newState;
            }
            if (world.m_46749_(below) && belowState.m_60734_() instanceof WeatheringCopperDoorBlock && ((DoubleBlockHalf)belowState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.LOWER)) {
                world.m_7731_(below, block.map(b -> b.m_152465_(belowState)).get(), 27);
                world.m_5898_(player, 3005, below, 0);
                return newState;
            }
            return newState;
        }
        return null;
    }

    public void m_153046_(BlockState state, ServerLevel world, BlockPos pos, Random pRandom) {
        Optional<Block> block;
        BlockPos blockpos;
        int l;
        int i = this.getAge().ordinal();
        int j = 0;
        int k = 0;
        Iterator iterator = BlockPos.m_121925_((BlockPos)pos, (int)4, (int)4, (int)4).iterator();
        while (iterator.hasNext() && (l = (blockpos = (BlockPos)iterator.next()).m_123333_((Vec3i)pos)) <= 4) {
            BlockState blockstate;
            Block block2;
            if (blockpos.equals((Object)pos) || !((block2 = (blockstate = world.m_8055_(blockpos)).m_60734_()) instanceof ChangeOverTimeBlock) || block2 instanceof WeatheringCopperDoorBlock) continue;
            Enum oenum = ((ChangeOverTimeBlock)block2).m_142297_();
            if (this.getAge().getClass() != oenum.getClass()) continue;
            int i1 = oenum.ordinal();
            if (i1 < i) {
                return;
            }
            if (i1 > i) {
                ++k;
                continue;
            }
            ++j;
        }
        float f = (float)(k + 1) / (float)(k + j + 1);
        float f1 = f * f * this.m_142377_();
        if (pRandom.nextFloat() < f1 && (block = CopperMaps.getNext(state.m_60734_())).isPresent()) {
            BlockPos below = pos.m_7495_();
            BlockPos above = pos.m_7494_();
            BlockState belowState = world.m_8055_(below);
            BlockState aboveState = world.m_8055_(above);
            BlockState newState = block.map(b -> b.m_152465_(state)).get();
            if (world.m_46749_(above) && aboveState.m_60734_() instanceof WeatheringCopperDoorBlock && ((DoubleBlockHalf)aboveState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.UPPER)) {
                world.m_7731_(above, block.map(b -> b.m_152465_(aboveState)).get(), 27);
                world.m_7731_(pos, newState, 27);
            } else if (world.m_46749_(below) && belowState.m_60734_() instanceof WeatheringCopperDoorBlock && ((DoubleBlockHalf)belowState.m_61143_((Property)DoorBlock.f_52730_)).equals((Object)DoubleBlockHalf.LOWER)) {
                world.m_7731_(below, block.map(b -> b.m_152465_(belowState)).get(), 27);
                world.m_7731_(pos, newState, 27);
            }
        }
    }
}

