/*
 * Decompiled with CFR 0.152.
 */
package net.onvoid.copperized.common;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantedChanceItemLootModifier
extends LootModifier {
    private final Item item;
    private final Enchantment enchantment;
    private final int level;
    private final double chance;
    private final boolean unique;

    public EnchantedChanceItemLootModifier(LootItemCondition[] conditions, Item item, Enchantment enchantment, int level, double chance, boolean unique) {
        super(conditions);
        this.item = item;
        this.enchantment = enchantment;
        this.level = level;
        this.chance = chance;
        this.unique = unique;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.unique && generatedLoot.stream().anyMatch(stack -> stack.m_41720_().equals(this.item))) {
            return generatedLoot;
        }
        Random random = new Random();
        if (random.nextDouble(1.0) <= this.chance) {
            ItemStack enchantedItem = new ItemStack((ItemLike)this.item, 1);
            EnchantmentHelper.m_44865_(Map.of(this.enchantment, this.level), (ItemStack)enchantedItem);
            generatedLoot.add(enchantedItem);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<EnchantedChanceItemLootModifier> {
        public EnchantedChanceItemLootModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditions) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"item")));
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"enchantment")));
            int level = GsonHelper.m_13927_((JsonObject)object, (String)"level");
            double chance = GsonHelper.m_144784_((JsonObject)object, (String)"chance");
            boolean unique = GsonHelper.m_13912_((JsonObject)object, (String)"unique");
            return new EnchantedChanceItemLootModifier(conditions, item, enchantment, level, chance, unique);
        }

        public JsonObject write(EnchantedChanceItemLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.item).toString());
            json.addProperty("enchantment", ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)instance.enchantment).toString());
            json.addProperty("level", (Number)instance.level);
            json.addProperty("chance", (Number)instance.chance);
            json.addProperty("unique", Boolean.valueOf(instance.unique));
            return json;
        }
    }
}

