/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.skinnedcarts.entity;

import com.mrbysco.skinnedcarts.config.CartConfig;
import com.mrbysco.skinnedcarts.entity.AbstractSkinnedCart;
import com.mrbysco.skinnedcarts.init.CartRegistry;
import java.util.Calendar;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class FrogCartEntity
extends AbstractSkinnedCart {
    public FrogCartEntity(EntityType<?> type, Level worldIn) {
        super(type, worldIn);
    }

    public FrogCartEntity(EntityType<?> type, Level worldIn, double x, double y, double z) {
        super(type, worldIn, x, y, z);
    }

    public FrogCartEntity(PlayMessages.SpawnEntity spawnEntity, Level worldIn) {
        this((EntityType)CartRegistry.FROG_CART.get(), worldIn);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    AbstractSkinnedCart.Type getSkinCartType() {
        return AbstractSkinnedCart.Type.FROG;
    }

    private void playLivingSound() {
        SoundEvent sound = (SoundEvent)CartRegistry.WEDNESDAY_FROG_CART.get();
        this.m_5496_(sound, this.getSoundVolume(), this.getSoundPitch());
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected float getSoundPitch() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f;
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (((Boolean)CartConfig.SERVER.WednesdayFrogCart.get()).booleanValue() && this.itsWednesday() && !this.f_19853_.f_46443_) {
            this.playLivingSound();
        }
        return super.m_7111_(player, vec, hand);
    }

    private boolean itsWednesday() {
        return Calendar.getInstance().get(7) == 4;
    }
}

