/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.skinnedcarts.entity;

import com.mrbysco.skinnedcarts.entity.BeeCartEntity;
import com.mrbysco.skinnedcarts.entity.ElephantCartEntity;
import com.mrbysco.skinnedcarts.entity.FrogCartEntity;
import com.mrbysco.skinnedcarts.entity.GreenFrogCartEntity;
import com.mrbysco.skinnedcarts.entity.LadybugCartEntity;
import com.mrbysco.skinnedcarts.entity.PandaCartEntity;
import com.mrbysco.skinnedcarts.entity.PelicanCartEntity;
import com.mrbysco.skinnedcarts.entity.PenguinCartEntity;
import com.mrbysco.skinnedcarts.entity.PufferFishCartEntity;
import com.mrbysco.skinnedcarts.entity.SnailCartEntity;
import com.mrbysco.skinnedcarts.entity.TurtleCartEntity;
import com.mrbysco.skinnedcarts.entity.WombatCartEntity;
import com.mrbysco.skinnedcarts.init.CartRegistry;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public abstract class AbstractSkinnedCart
extends AbstractMinecart {
    public AbstractSkinnedCart(EntityType<?> type, Level worldIn) {
        super(type, worldIn);
    }

    public AbstractSkinnedCart(EntityType<?> type, Level worldIn, double x, double y, double z) {
        super(type, worldIn, x, y, z);
    }

    public void m_7617_(DamageSource source) {
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemstack = this.getReturnItem();
            if (this.m_8077_()) {
                itemstack.m_41714_(this.m_7770_());
            }
            this.m_19983_(itemstack);
        }
    }

    public ItemStack getReturnItem() {
        return new ItemStack((ItemLike)this.getSkinCartType().getReturnItem().get());
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    abstract Type getSkinCartType();

    public ItemStack getPickedResult(HitResult target) {
        return this.getCartItem();
    }

    public ItemStack m_142340_() {
        return this.getReturnItem();
    }

    public boolean isPoweredCart() {
        return false;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult ret = super.m_6096_(player, hand);
        if (ret.m_19077_()) {
            return ret;
        }
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (this.m_20160_()) {
            return InteractionResult.PASS;
        }
        if (!this.f_19853_.f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6025_(int x, int y, int z, boolean receivingPower) {
        if (receivingPower) {
            if (this.m_20160_()) {
                this.m_20153_();
            }
            if (this.m_38176_() == 0) {
                this.m_38160_(-this.m_38177_());
                this.m_38154_(10);
                this.m_38109_(50.0f);
                this.m_5834_();
            }
        }
    }

    public static AbstractSkinnedCart create(Level worldIn, double x, double y, double z, Type typeIn) {
        AbstractSkinnedCart cart = switch (typeIn) {
            default -> new TurtleCartEntity((EntityType)CartRegistry.TURTLE_CART.get(), worldIn, x, y, z);
            case Type.ELEPHANT -> new ElephantCartEntity((EntityType)CartRegistry.ELEPHANT_CART.get(), worldIn, x, y, z);
            case Type.FROG -> new FrogCartEntity((EntityType)CartRegistry.FROG_CART.get(), worldIn, x, y, z);
            case Type.PANDA -> new PandaCartEntity((EntityType)CartRegistry.PANDA_CART.get(), worldIn, x, y, z);
            case Type.PELICAN -> new PelicanCartEntity((EntityType)CartRegistry.PELICAN_CART.get(), worldIn, x, y, z);
            case Type.PUFFERFISH -> new PufferFishCartEntity((EntityType)CartRegistry.PUFFERFISH_CART.get(), worldIn, x, y, z);
            case Type.SNAIL -> new SnailCartEntity((EntityType)CartRegistry.SNAIL_CART.get(), worldIn, x, y, z);
            case Type.BEE -> new BeeCartEntity((EntityType)CartRegistry.BEE_CART.get(), worldIn, x, y, z);
            case Type.GREEN_FROG -> new GreenFrogCartEntity((EntityType)CartRegistry.GREEN_FROG_CART.get(), worldIn, x, y, z);
            case Type.LADYBUG -> new LadybugCartEntity((EntityType)CartRegistry.LADYBUG_CART.get(), worldIn, x, y, z);
            case Type.PENGUIN -> new PenguinCartEntity((EntityType)CartRegistry.PENGUIN_CART.get(), worldIn, x, y, z);
            case Type.WOMBAT -> new WombatCartEntity((EntityType)CartRegistry.WOMBAT_CART.get(), worldIn, x, y, z);
        };
        return cart;
    }

    public static enum Type {
        ELEPHANT((Supplier<Item>)CartRegistry.ELEPHANT_CART_ITEM),
        FROG((Supplier<Item>)CartRegistry.FROG_CART_ITEM),
        PANDA((Supplier<Item>)CartRegistry.PANDA_CART_ITEM),
        PELICAN((Supplier<Item>)CartRegistry.PELICAN_CART_ITEM),
        PUFFERFISH((Supplier<Item>)CartRegistry.PUFFERFISH_CART_ITEM),
        SNAIL((Supplier<Item>)CartRegistry.SNAIL_CART_ITEM),
        TURTLE((Supplier<Item>)CartRegistry.TURTLE_CART_ITEM),
        BEE((Supplier<Item>)CartRegistry.BEE_CART_ITEM),
        GREEN_FROG((Supplier<Item>)CartRegistry.GREEN_FROG_CART_ITEM),
        LADYBUG((Supplier<Item>)CartRegistry.LADYBUG_CART_ITEM),
        PENGUIN((Supplier<Item>)CartRegistry.PENGUIN_CART_ITEM),
        WOMBAT((Supplier<Item>)CartRegistry.WOMBAT_CART_ITEM);

        private final Supplier<Item> returnItem;

        private Type(Supplier<Item> itemSupplier) {
            this.returnItem = itemSupplier;
        }

        public Supplier<Item> getReturnItem() {
            return this.returnItem;
        }
    }
}

