/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.skinnedcarts.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class RenderSkinnedCart<T extends AbstractMinecart>
extends EntityRenderer<T> {
    private static ResourceLocation CART_TEXTURES = RenderSkinnedCart.createLocation("minecart_frog");
    private final EntityModel<T> modelMinecart;

    public RenderSkinnedCart(EntityRendererProvider.Context context, EntityModel<T> model) {
        super(context);
        this.modelMinecart = model;
        this.f_114477_ = 0.7f;
    }

    public static ResourceLocation createLocation(String cartName) {
        return new ResourceLocation("skinnedcarts:textures/entity/" + cartName + ".png");
    }

    protected void renderBlockState(T entityIn, float partialTicks, BlockState stateIn, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        Minecraft.m_91087_().m_91289_().m_110912_(stateIn, poseStack, bufferSource, packedLightIn, OverlayTexture.f_118083_);
    }

    public void render(T entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        super.m_7392_(entityIn, entityYaw, partialTicks, poseStack, bufferSource, packedLightIn);
        poseStack.m_85836_();
        long i = (long)entityIn.m_142049_() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        poseStack.m_85837_((double)f, (double)f1, (double)f2);
        double d0 = Mth.m_14139_((double)partialTicks, (double)((AbstractMinecart)entityIn).f_19790_, (double)entityIn.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)((AbstractMinecart)entityIn).f_19791_, (double)entityIn.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)((AbstractMinecart)entityIn).f_19792_, (double)entityIn.m_20189_());
        double d3 = 0.3f;
        Vec3 Vector3d = entityIn.m_38179_(d0, d1, d2);
        float f3 = Mth.m_14179_((float)partialTicks, (float)((AbstractMinecart)entityIn).f_19860_, (float)entityIn.m_146909_());
        if (Vector3d != null) {
            Vec3 Vector3d1 = entityIn.m_38096_(d0, d1, d2, (double)0.3f);
            Vec3 Vector3d2 = entityIn.m_38096_(d0, d1, d2, (double)-0.3f);
            if (Vector3d1 == null) {
                Vector3d1 = Vector3d;
            }
            if (Vector3d2 == null) {
                Vector3d2 = Vector3d;
            }
            poseStack.m_85837_(Vector3d.f_82479_ - d0, (Vector3d1.f_82480_ + Vector3d2.f_82480_) / 2.0 - d1, Vector3d.f_82481_ - d2);
            Vec3 Vector3d3 = Vector3d2.m_82520_(-Vector3d1.f_82479_, -Vector3d1.f_82480_, -Vector3d1.f_82481_);
            if (Vector3d3.m_82553_() != 0.0) {
                Vector3d3 = Vector3d3.m_82541_();
                entityYaw = (float)(Math.atan2(Vector3d3.f_82481_, Vector3d3.f_82479_) * 180.0 / Math.PI);
                f3 = (float)(Math.atan(Vector3d3.f_82480_) * 73.0);
            }
        }
        if ((entityYaw %= 360.0f) < 0.0f) {
            entityYaw += 360.0f;
        }
        entityYaw += 360.0f;
        double serverYaw = entityIn.m_146908_();
        serverYaw += 180.0;
        if ((serverYaw %= 360.0) < 0.0) {
            serverYaw += 360.0;
        }
        if (Math.abs((double)entityYaw - (serverYaw += 360.0)) > 90.0) {
            entityYaw += 180.0f;
            f3 = -f3;
        }
        poseStack.m_85837_(0.0, 0.375, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-f3));
        float f5 = (float)entityIn.m_38176_() - partialTicks;
        float f6 = entityIn.m_38169_() - partialTicks;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f5) * f5 * f6 / 10.0f * (float)entityIn.m_38177_()));
        }
        int j = entityIn.m_38183_();
        BlockState blockstate = entityIn.m_38178_();
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            poseStack.m_85836_();
            float f4 = 0.75f;
            poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            poseStack.m_85837_(-0.5, (double)((float)(j - 8) / 16.0f), 0.5);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            this.renderBlockState(entityIn, partialTicks, blockstate, poseStack, bufferSource, packedLightIn);
            poseStack.m_85849_();
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.modelMinecart.m_6973_(entityIn, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.modelMinecart.m_103119_(this.getTextureLocation(entityIn)));
        this.modelMinecart.m_7695_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(T entity) {
        return CART_TEXTURES;
    }
}

