/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.tag;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.supermartijn642.core.data.tag.CustomTagEntries;
import com.supermartijn642.core.data.tag.CustomTagEntry;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;

public class TagEntryAdapter
implements Tag.Entry {
    final ResourceLocation identifier;
    final CustomTagEntry customEntry;
    private Registry<?> registry;

    TagEntryAdapter(ResourceLocation identifier, CustomTagEntry customEntry) {
        this.identifier = identifier;
        this.customEntry = customEntry;
    }

    public void setRegistry(Registry<?> registry) {
        this.registry = registry;
    }

    public <T> boolean m_7657_(final Function<ResourceLocation, Tag<T>> tagLookup, final Function<ResourceLocation, T> elementLookup, Consumer<T> entryConsumer) {
        CustomTagEntry.TagEntryResolutionContext context = new CustomTagEntry.TagEntryResolutionContext<T>(){

            @Override
            public T getElement(ResourceLocation identifier) {
                return elementLookup.apply(identifier);
            }

            @Override
            public Collection<T> getTag(ResourceLocation identifier) {
                return ((Tag)tagLookup.apply(identifier)).m_6497_();
            }

            @Override
            public Collection<T> getAllElements() {
                return TagEntryAdapter.this.registry.m_203611_().collect(Collectors.toList());
            }

            @Override
            public Set<ResourceLocation> getAllIdentifiers() {
                return TagEntryAdapter.this.registry.m_6566_();
            }
        };
        Collection<T> entries = this.customEntry.resolve(context);
        if (entries != null) {
            entries.forEach(entryConsumer);
        }
        return true;
    }

    public void m_141918_(Consumer<ResourceLocation> consumer) {
        Collection<ResourceLocation> dependencies = this.customEntry.getTagDependencies();
        if (dependencies != null) {
            dependencies.forEach(consumer);
        }
    }

    public boolean m_142746_(Predicate<ResourceLocation> elementTest, Predicate<ResourceLocation> tagTest) {
        return true;
    }

    public String toString() {
        return "'" + this.identifier + "'{" + this.customEntry + "}";
    }

    public void m_6383_(JsonArray array) {
        array.add((JsonElement)CustomTagEntries.serialize(this));
    }
}

