/*
 * Decompiled with CFR 0.152.
 */
package shiroroku.tarotcards.World;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import shiroroku.tarotcards.Configuration;

public class TarotLootAdditions
extends LootModifier {
    private final List<Item> items;

    public TarotLootAdditions(LootItemCondition[] conditionsIn, List<Item> items) {
        super(conditionsIn);
        this.items = items;
    }

    @NotNull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (((Boolean)Configuration.do_loot_generation.get()).booleanValue() && (double)context.m_78933_().nextFloat() < (Double)Configuration.default_loot_chance.get()) {
            generatedLoot.add(new ItemStack((ItemLike)this.items.get(context.m_78933_().nextInt(this.items.size()))));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<TarotLootAdditions> {
        public TarotLootAdditions read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            ArrayList<Item> output = new ArrayList<Item>();
            JsonArray items = GsonHelper.m_13933_((JsonObject)object, (String)"items");
            for (JsonElement jo : items) {
                output.add((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)jo.getAsString())));
            }
            return new TarotLootAdditions(ailootcondition, output);
        }

        public JsonObject write(TarotLootAdditions instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            JsonArray items = new JsonArray();
            for (Item tarot : instance.items) {
                items.add(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)tarot).toString());
            }
            json.add("items", (JsonElement)items);
            return null;
        }
    }
}

