/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.managers.machine.SmelterRecipeManager;
import cofh.thermal.core.util.recipes.machine.SmelterRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineSmelterScreen;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;

public class SmelterRecipeCategory
extends ThermalRecipeCategory<SmelterRecipe> {
    public SmelterRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachineSmelterScreen.TEXTURE, 26, 11, 140, 62).addPadding(0, 0, 16, 8).build();
        this.name = StringHelper.getTextComponent((String)((Block)ThermalCore.BLOCKS.get("machine_smelter")).m_7705_());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends SmelterRecipe> getRecipeClass() {
        return SmelterRecipe.class;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SmelterRecipe recipe, IFocusGroup focuses) {
        int i;
        List inputs = recipe.getInputItems();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(recipe.getOutputItems().size());
        List catalysts = SmelterRecipeManager.instance().getCatalysts();
        for (ItemStack stack : recipe.getOutputItems()) {
            outputs.add(ItemHelper.cloneStack((ItemStack)stack));
        }
        for (int i2 = 0; i2 < outputs.size(); ++i2) {
            float chance = ((Float)recipe.getOutputItemChances().get(i2)).floatValue();
            if (!(chance > 1.0f)) continue;
            ((ItemStack)outputs.get(i2)).m_41764_((int)chance);
        }
        IRecipeSlotBuilder[] inputSlots = new IRecipeSlotBuilder[3];
        IRecipeSlotBuilder[] outputSlots = new IRecipeSlotBuilder[4];
        inputSlots[0] = builder.addSlot(RecipeIngredientRole.INPUT, 43, 6);
        inputSlots[1] = builder.addSlot(RecipeIngredientRole.INPUT, 25, 6);
        inputSlots[2] = builder.addSlot(RecipeIngredientRole.INPUT, 61, 6);
        IRecipeSlotBuilder catalystSlot = builder.addSlot(RecipeIngredientRole.INPUT, 43, 42);
        for (i = 0; i < inputs.size(); ++i) {
            inputSlots[i].addIngredients((Ingredient)inputs.get(i));
        }
        if (recipe.isCatalyzable()) {
            ((IRecipeSlotBuilder)catalystSlot.addItemStacks(catalysts)).addTooltipCallback(TCoreJeiPlugin.catalystTooltip());
        }
        outputSlots[0] = builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 15);
        outputSlots[1] = builder.addSlot(RecipeIngredientRole.OUTPUT, 133, 15);
        outputSlots[2] = builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 33);
        outputSlots[3] = builder.addSlot(RecipeIngredientRole.OUTPUT, 133, 33);
        for (i = 0; i < outputs.size(); ++i) {
            ((IRecipeSlotBuilder)outputSlots[i].addItemStack((ItemStack)outputs.get(i))).addTooltipCallback(TCoreJeiPlugin.catalyzedOutputTooltip((float)((Float)recipe.getOutputItemChances().get(i)).floatValue(), (boolean)recipe.isCatalyzable()));
        }
    }

    public void draw(SmelterRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, recipeSlotsView, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 84, 24);
        this.speedBackground.draw(matrixStack, 43, 24);
        this.progress.draw(matrixStack, 84, 24);
        this.speed.draw(matrixStack, 43, 24);
    }
}

