/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import snownee.snow.CoreModule;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.ModSnowLayerBlock;
import snownee.snow.entity.FallingSnowEntity;
import snownee.snow.mixin.IceBlockAccess;

public class WorldTickHandler {
    public static void tick(ServerLevel level, LevelChunk chunk, Random random) {
        Biome.Precipitation biome$precipitation;
        int y;
        if (random.nextInt(16) != 0) {
            return;
        }
        int x = chunk.m_7697_().m_45604_();
        BlockPos.MutableBlockPos pos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, level.m_46496_(x, 0, y = chunk.m_7697_().m_45605_(), 15)).m_122032_();
        if (!level.isAreaLoaded((BlockPos)pos, 1)) {
            return;
        }
        pos.m_122173_(Direction.DOWN);
        Holder biomeHolder = level.m_204166_((BlockPos)pos);
        Biome biome = (Biome)biomeHolder.m_203334_();
        BlockState state = null;
        if (biome.m_47477_((LevelReader)level, (BlockPos)pos)) {
            level.m_46597_((BlockPos)pos, Blocks.f_50126_.m_49966_());
        } else if (ModUtil.iceMeltsInWarmBiomes(biome) && (state = level.m_8055_((BlockPos)pos)).m_60713_(Blocks.f_50126_) && ModUtil.shouldMelt((Level)level, (BlockPos)pos)) {
            ((IceBlockAccess)state.m_60734_()).callMelt(state, (Level)level, (BlockPos)pos);
            state = level.m_8055_((BlockPos)pos);
        }
        if (level.m_46471_()) {
            int blizzard;
            if (state == null) {
                state = level.m_8055_((BlockPos)pos);
            }
            int n = blizzard = SnowCommonConfig.snowGravity ? level.m_46469_().m_46215_(CoreModule.BLIZZARD_STRENGTH) : 0;
            if (blizzard > 0) {
                WorldTickHandler.doBlizzard(level, (BlockPos)pos, blizzard);
                return;
            }
            biome$precipitation = biome.m_47530_();
            if (biome$precipitation == Biome.Precipitation.RAIN && ModUtil.coldEnoughToSnow((Level)level, (BlockPos)pos, (Holder<Biome>)biomeHolder)) {
                biome$precipitation = Biome.Precipitation.SNOW;
            }
        } else {
            return;
        }
        state.m_60734_().m_141997_(state, (Level)level, (BlockPos)pos, biome$precipitation);
        if (!ModUtil.coldEnoughToSnow((Level)level, (BlockPos)pos, (Holder<Biome>)biomeHolder)) {
            return;
        }
        if (!ModSnowLayerBlock.canContainState(state)) {
            if (SnowCommonConfig.snowAccumulationMaxLayers < 9 && state.m_60713_(Blocks.f_50125_)) {
                return;
            }
            state = level.m_8055_((BlockPos)pos.m_122173_(Direction.UP));
            if (!state.m_60795_() && !ModSnowLayerBlock.canContainState(state)) {
                return;
            }
        }
        if (state.m_60795_() && !Blocks.f_50125_.m_49966_().m_60710_((LevelReader)level, (BlockPos)pos)) {
            return;
        }
        if (level.m_45517_(LightLayer.BLOCK, (BlockPos)pos.m_122173_(Direction.UP)) >= 10) {
            return;
        }
        ModSnowLayerBlock.convert((LevelAccessor)level, (BlockPos)pos.m_122173_(Direction.DOWN), state, 1, 3);
        for (int i = 0; i < 5 && !state.m_204336_(BlockTags.f_13031_) && !state.m_204336_(BlockTags.f_13030_) && ((state = level.m_8055_((BlockPos)pos.m_122173_(Direction.DOWN))).m_60795_() || ModSnowLayerBlock.canContainState(state)); ++i) {
            if (!((ModSnowLayerBlock)CoreModule.BLOCK.get()).m_7898_(state, (LevelReader)level, (BlockPos)pos)) continue;
            pos.m_122173_(Direction.UP);
            if (level.m_8055_((BlockPos)pos).m_60734_() instanceof SnowLayerBlock || level.m_45517_(LightLayer.BLOCK, (BlockPos)pos) >= 10) break;
            ModSnowLayerBlock.convert((LevelAccessor)level, (BlockPos)pos.m_122173_(Direction.DOWN), state, 1, 3);
        }
    }

    private static void doBlizzard(ServerLevel world, BlockPos pos, int blizzard) {
        if (pos.m_123342_() == world.m_141928_()) {
            return;
        }
        int frequency = world.m_46469_().m_46215_(CoreModule.BLIZZARD_FREQUENCY);
        if ((frequency = Mth.m_14045_((int)frequency, (int)0, (int)10000)) == 0) {
            return;
        }
        int i = world.f_46441_.nextInt(10000);
        if (frequency != 10000 && i >= frequency) {
            return;
        }
        if ((blizzard = Mth.m_14045_((int)blizzard, (int)1, (int)8)) > 1) {
            blizzard = world.f_46441_.nextInt(blizzard) + 1;
        }
        pos = pos.m_6630_(64);
        FallingSnowEntity entity = new FallingSnowEntity((Level)world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() + 0.5, blizzard);
        world.m_7967_((Entity)entity);
    }
}

