/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.misc.trades;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class EnchantItemTrade
implements VillagerTrades.ItemListing {
    private final ItemStack itemStack;
    private final int enchantXp;
    private final int baseEmeraldCost;
    private final int maxUses;
    private final int villagerXp;
    private final int enchantmentCount;
    private final float priceMultiplier;

    public EnchantItemTrade(Item item, int enchantXp, int enchantmentCount, int emeralds, int maxUses, int villagerXp) {
        this(item, enchantXp, enchantmentCount, emeralds, maxUses, villagerXp, 0.05f);
    }

    public EnchantItemTrade(Item item, int enchantXp, int enchantmentCount, int emeralds, int maxUses, int villagerXp, float priceMultiplier) {
        this.itemStack = new ItemStack((ItemLike)item);
        this.enchantXp = enchantXp;
        this.baseEmeraldCost = emeralds;
        this.maxUses = maxUses;
        this.villagerXp = villagerXp;
        this.enchantmentCount = enchantmentCount;
        this.priceMultiplier = priceMultiplier;
    }

    public MerchantOffer m_5670_(Entity entity, Random random) {
        int i = Math.max(6, this.enchantXp + 5 - random.nextInt(5));
        ItemStack itemstack = this.enchant(random, new ItemStack((ItemLike)this.itemStack.m_41720_()), i, this.enchantmentCount);
        int j = Math.min(this.baseEmeraldCost + i, 64);
        ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42616_, j);
        return new MerchantOffer(itemstack1, itemstack, this.maxUses, this.villagerXp, this.priceMultiplier);
    }

    public ItemStack enchant(Random random, ItemStack stack, int enchantXp, int howManyEnchants) {
        List<EnchantmentInstance> list = EnchantItemTrade.selectEnchantment(random, stack, enchantXp, howManyEnchants);
        for (EnchantmentInstance enchantmentinstance : list) {
            stack.m_41663_(enchantmentinstance.f_44947_, enchantmentinstance.f_44948_);
        }
        return stack;
    }

    public static List<EnchantmentInstance> selectEnchantment(Random random, ItemStack stacks, int expIThink, int enchantmentCount) {
        ArrayList list = Lists.newArrayList();
        Item item = stacks.m_41720_();
        int i = stacks.getItemEnchantability();
        if (i <= 0) {
            return list;
        }
        expIThink += 1 + random.nextInt(i / 4 + 1) + random.nextInt(i / 4 + 1);
        float f = (random.nextFloat() + random.nextFloat() - 1.0f) * 0.15f;
        expIThink = Mth.m_14045_((int)Math.round((float)expIThink + (float)expIThink * f), (int)1, (int)Integer.MAX_VALUE);
        List<EnchantmentInstance> list1 = EnchantItemTrade.getAvailableEnchantmentResults(expIThink, stacks);
        int ehcantmentsSoFar = 0;
        if (!list1.isEmpty()) {
            WeightedRandom.m_146317_((Random)random, list1).ifPresent(list::add);
            while (ehcantmentsSoFar < enchantmentCount && random.nextInt(25) != 0) {
                if (!list.isEmpty()) {
                    EnchantmentHelper.m_44862_(list1, (EnchantmentInstance)((EnchantmentInstance)Util.m_137509_((List)list)));
                }
                if (list1.isEmpty()) break;
                WeightedRandom.m_146317_((Random)random, list1).ifPresent(list::add);
                ++ehcantmentsSoFar;
                expIThink /= 2;
            }
        }
        return list;
    }

    private static List<EnchantmentInstance> getAvailableEnchantmentResults(int levels, ItemStack stack) {
        ArrayList list = Lists.newArrayList();
        Item item = stack.m_41720_();
        boolean flag = stack.m_150930_(Items.f_42517_);
        block0: for (Enchantment enchantment : Registry.f_122825_) {
            if (!enchantment.m_6594_() || !enchantment.m_6592_() || !enchantment.canApplyAtEnchantingTable(stack) && (!flag || !enchantment.isAllowedOnBooks())) continue;
            for (int i = enchantment.m_6586_(); i > enchantment.m_44702_() - 1; --i) {
                if (levels < enchantment.m_6183_(i) || levels > enchantment.m_6175_(i)) continue;
                list.add(new EnchantmentInstance(enchantment, i));
                continue block0;
            }
        }
        return list;
    }
}

