/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.misc;

import com.github.alexthe668.domesticationinnovation.server.entity.DIVillagerRegistry;
import com.github.alexthe668.domesticationinnovation.server.misc.DIEntityTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class PetshopStructurePoolElement
extends LegacySinglePoolElement {
    public static final ResourceLocation CHEST = new ResourceLocation("domesticationinnovation", "chests/petshop_chest");
    public static final ResourceLocation FISHTANK_MOBS = new ResourceLocation("domesticationinnovation", "petstore_fishtank");
    public static final ResourceLocation CAGE_0_MOBS = new ResourceLocation("domesticationinnovation", "petstore_cage_0");
    public static final ResourceLocation CAGE_1_MOBS = new ResourceLocation("domesticationinnovation", "petstore_cage_1");
    public static final ResourceLocation CAGE_2_MOBS = new ResourceLocation("domesticationinnovation", "petstore_cage_2");
    public static final ResourceLocation CAGE_3_MOBS = new ResourceLocation("domesticationinnovation", "petstore_cage_3");
    private static boolean initializedMobLists = false;
    private static EntityType[] fishtankMobs = null;
    private static EntityType[] cage0Mobs = null;
    private static EntityType[] cage1Mobs = null;
    private static EntityType[] cage2Mobs = null;
    private static EntityType[] cage3Mobs = null;
    public static final Codec<PetshopStructurePoolElement> CODEC = RecordCodecBuilder.create(p_210357_ -> p_210357_.group((App)PetshopStructurePoolElement.m_210465_(), (App)PetshopStructurePoolElement.m_210462_(), (App)PetshopStructurePoolElement.m_210538_()).apply((Applicative)p_210357_, PetshopStructurePoolElement::new));

    protected PetshopStructurePoolElement(Either<ResourceLocation, StructureTemplate> either, Holder<StructureProcessorList> p_210349_, StructureTemplatePool.Projection p_210350_) {
        super(either, p_210349_, p_210350_);
    }

    public PetshopStructurePoolElement(ResourceLocation resourceLocation, Holder<StructureProcessorList> processors) {
        super(Either.left((Object)resourceLocation), processors, StructureTemplatePool.Projection.RIGID);
    }

    public void m_210472_(LevelAccessor levelAccessor, StructureTemplate.StructureBlockInfo structureBlockInfo, BlockPos pos, Rotation rotation, Random random, BoundingBox box) {
        String contents = structureBlockInfo.f_74677_.m_128461_("metadata");
        if (!initializedMobLists) {
            fishtankMobs = this.getAllMatchingEntities(DIEntityTags.PETSTORE_FISHTANK).toArray(new EntityType[0]);
            cage0Mobs = this.getAllMatchingEntities(DIEntityTags.PETSTORE_CAGE_0).toArray(new EntityType[0]);
            cage1Mobs = this.getAllMatchingEntities(DIEntityTags.PETSTORE_CAGE_1).toArray(new EntityType[0]);
            cage2Mobs = this.getAllMatchingEntities(DIEntityTags.PETSTORE_CAGE_2).toArray(new EntityType[0]);
            cage3Mobs = this.getAllMatchingEntities(DIEntityTags.PETSTORE_CAGE_3).toArray(new EntityType[0]);
            initializedMobLists = true;
        }
        switch (contents) {
            case "petshop_water": {
                BlockState state = Blocks.f_49990_.m_49966_();
                float f = random.nextFloat();
                if (f < 0.5f) {
                    state = Blocks.f_50037_.m_49966_();
                } else if (f < 0.75f) {
                    state = (BlockState)(switch (random.nextInt(5)) {
                        case 1 -> Blocks.f_50594_;
                        case 2 -> Blocks.f_50595_;
                        case 3 -> Blocks.f_50596_;
                        case 4 -> Blocks.f_50597_;
                        default -> Blocks.f_50598_;
                    }).m_49966_().m_61124_((Property)BaseCoralPlantTypeBlock.f_49158_, (Comparable)Boolean.valueOf(true));
                }
                this.spawnAnimalsAt(levelAccessor, structureBlockInfo.f_74675_, 2, random, fishtankMobs);
                levelAccessor.m_7731_(structureBlockInfo.f_74675_, state, 2);
                break;
            }
            case "petshop_chest": {
                levelAccessor.m_7731_(structureBlockInfo.f_74675_, Blocks.f_50016_.m_49966_(), 2);
                RandomizableContainerBlockEntity.m_59620_((BlockGetter)levelAccessor, (Random)random, (BlockPos)structureBlockInfo.f_74675_.m_7495_(), (ResourceLocation)CHEST);
                break;
            }
            case "petshop_cage_0": {
                this.spawnAnimalsAt(levelAccessor, structureBlockInfo.f_74675_, 1 + random.nextInt(2), random, cage0Mobs);
                levelAccessor.m_7731_(structureBlockInfo.f_74675_, Blocks.f_50016_.m_49966_(), 4);
                break;
            }
            case "petshop_cage_1": {
                this.spawnAnimalsAt(levelAccessor, structureBlockInfo.f_74675_, 2 + random.nextInt(2), random, cage1Mobs);
                levelAccessor.m_7731_(structureBlockInfo.f_74675_, Blocks.f_50016_.m_49966_(), 2);
                break;
            }
            case "petshop_cage_2": {
                this.spawnAnimalsAt(levelAccessor, structureBlockInfo.f_74675_, 1 + random.nextInt(2), random, cage2Mobs);
                levelAccessor.m_7731_(structureBlockInfo.f_74675_, Blocks.f_50016_.m_49966_(), 2);
                break;
            }
            case "petshop_cage_3": {
                this.spawnAnimalsAt(levelAccessor, structureBlockInfo.f_74675_, 1, random, cage3Mobs);
                levelAccessor.m_7731_(structureBlockInfo.f_74675_, Blocks.f_50016_.m_49966_(), 2);
            }
        }
    }

    private List<EntityType<?>> getAllMatchingEntities(TagKey<EntityType<?>> tag) {
        return ForgeRegistries.ENTITIES.getValues().stream().filter(type -> type.m_204039_(tag)).toList();
    }

    public void spawnAnimalsAt(LevelAccessor accessor, BlockPos at, int count, Random random, EntityType ... types) {
        if (types.length > 0 && count > 0 && accessor.m_8055_(at).m_60734_() == Blocks.f_50677_ && accessor instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)accessor;
            for (int i = 0; i < count; ++i) {
                int index = types.length == 1 ? 0 : random.nextInt(types.length - 1);
                Entity entity = types[index].m_20615_((Level)serverLevel.m_6018_());
                entity.m_146884_(Vec3.m_82539_((Vec3i)at));
                entity.m_146922_((float)(random.nextInt(360) - 180));
                entity.m_146926_((float)(random.nextInt(360) - 180));
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21530_();
                    mob.m_6518_(serverLevel, serverLevel.m_6436_(mob.m_142538_()), MobSpawnType.STRUCTURE, null, null);
                }
                serverLevel.m_47205_(entity);
            }
        }
    }

    public boolean m_207251_(StructureManager p_210435_, WorldGenLevel p_210436_, StructureFeatureManager p_210437_, ChunkGenerator p_210438_, BlockPos p_210439_, BlockPos p_210440_, Rotation p_210441_, BoundingBox p_210442_, Random p_210443_, boolean p_210444_) {
        StructurePlaceSettings structureplacesettings;
        StructureTemplate structuretemplate = p_210435_.m_74341_((ResourceLocation)this.f_210411_.left().get());
        if (!structuretemplate.m_74536_((ServerLevelAccessor)p_210436_, p_210439_, p_210440_, structureplacesettings = this.m_207169_(p_210441_, p_210442_, p_210444_), p_210443_, 18)) {
            return false;
        }
        for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : StructureTemplate.processBlockInfos((LevelAccessor)p_210436_, (BlockPos)p_210439_, (BlockPos)p_210440_, (StructurePlaceSettings)structureplacesettings, (List)this.m_210457_(p_210435_, p_210439_, p_210441_, false), (StructureTemplate)structuretemplate)) {
            this.m_210472_((LevelAccessor)p_210436_, structuretemplate$structureblockinfo, p_210439_, p_210441_, p_210443_, p_210442_);
        }
        return true;
    }

    protected StructurePlaceSettings m_207169_(Rotation p_210421_, BoundingBox p_210422_, boolean p_210423_) {
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings();
        structureplacesettings.m_74381_(p_210422_);
        structureplacesettings.m_74379_(p_210421_);
        structureplacesettings.m_74402_(true);
        structureplacesettings.m_74392_(false);
        structureplacesettings.m_74405_(true);
        if (!p_210423_) {
            structureplacesettings.m_74383_((StructureProcessor)JigsawReplacementProcessor.f_74122_);
        }
        ((StructureProcessorList)this.f_210412_.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)structureplacesettings).m_74383_(arg_0));
        this.m_210539_().m_210609_().forEach(arg_0 -> ((StructurePlaceSettings)structureplacesettings).m_74383_(arg_0));
        return structureplacesettings;
    }

    public StructurePoolElementType<?> m_207234_() {
        return DIVillagerRegistry.PETSHOP_TYPE;
    }

    public String toString() {
        return "PetShop[" + this.f_210411_ + "]";
    }
}

