/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.misc;

import com.github.alexthe668.domesticationinnovation.server.misc.RespawnRequest;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class DIWorldData
extends SavedData {
    private static final String IDENTIFIER = "domesticationinnovation_world_data";
    private final List<RespawnRequest> respawnRequestList = new ArrayList<RespawnRequest>();

    private DIWorldData() {
    }

    public static DIWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.m_142572_().m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            DIWorldData data = (DIWorldData)storage.m_164861_(DIWorldData::load, DIWorldData::new, IDENTIFIER);
            if (data != null) {
                data.m_77762_();
            }
            return data;
        }
        return null;
    }

    public static DIWorldData load(CompoundTag nbt) {
        DIWorldData data = new DIWorldData();
        if (nbt.m_128441_("RespawnList")) {
            ListTag listtag = nbt.m_128437_("RespawnList", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag innerTag = listtag.m_128728_(i);
                data.respawnRequestList.add(new RespawnRequest(innerTag.m_128461_("EntityType"), innerTag.m_128461_("DimensionIn"), innerTag.m_128469_("EntityData"), new BlockPos(innerTag.m_128451_("X"), innerTag.m_128451_("Y"), innerTag.m_128451_("Z")), innerTag.m_128454_("Timestamp"), innerTag.m_128461_("EntityNametag")));
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        if (!this.respawnRequestList.isEmpty()) {
            ListTag listTag = new ListTag();
            for (RespawnRequest request : this.respawnRequestList) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("EntityType", request.getEntityTypeLoc());
                tag.m_128359_("DimensionIn", request.getDimension());
                tag.m_128365_("EntityData", (Tag)request.getEntityData());
                tag.m_128405_("X", request.getBedPosition().m_123341_());
                tag.m_128405_("Y", request.getBedPosition().m_123342_());
                tag.m_128405_("Z", request.getBedPosition().m_123343_());
                tag.m_128356_("Timestamp", request.getTimestamp());
                tag.m_128359_("EntityNametag", request.getNametag());
                listTag.add((Object)tag);
            }
            compound.m_128365_("RespawnList", (Tag)listTag);
        }
        return compound;
    }

    public void addRespawnRequest(RespawnRequest request) {
        this.respawnRequestList.add(request);
    }

    public void removeRespawnRequest(RespawnRequest request) {
        this.respawnRequestList.remove(request);
    }

    public List<RespawnRequest> getRequestsFor(Level level, BlockPos pos) {
        ArrayList<RespawnRequest> list = new ArrayList<RespawnRequest>();
        String dimension = level.m_46472_().toString();
        for (RespawnRequest request : this.respawnRequestList) {
            if (!dimension.equals(request.getDimension()) || !pos.equals((Object)request.getBedPosition())) continue;
            list.add(request);
        }
        return list;
    }
}

