/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.entity.ai;

import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.github.alexthe668.domesticationinnovation.server.enchantment.DIEnchantmentRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.CommandableMob;
import com.github.alexthe668.domesticationinnovation.server.entity.ModifedToBeTameable;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FollowOwner2Goal
extends Goal {
    private final Animal tamable;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private final float stopDistance;
    private final float startDistance;
    private final boolean canFly;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public FollowOwner2Goal(Animal animal, double speedModifier, float startDistance, float stopDistance, boolean flies) {
        this.tamable = animal;
        this.level = animal.f_19853_;
        this.speedModifier = speedModifier;
        this.navigation = animal.m_21573_();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.canFly = flies;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        CommandableMob commandableMob;
        LivingEntity livingentity = ((ModifedToBeTameable)this.tamable).getTameOwner();
        Animal animal = this.tamable;
        if (animal instanceof CommandableMob && (commandableMob = (CommandableMob)animal).getCommand() != 2 && ((Boolean)DomesticationMod.CONFIG.trinaryCommandSystem.get()).booleanValue()) {
            return false;
        }
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (((ModifedToBeTameable)this.tamable).isStayingStill()) {
            return false;
        }
        if (this.tamable.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        CommandableMob commandableMob;
        Animal animal = this.tamable;
        if (animal instanceof CommandableMob && (commandableMob = (CommandableMob)animal).getCommand() != 2 && ((Boolean)DomesticationMod.CONFIG.trinaryCommandSystem.get()).booleanValue()) {
            return false;
        }
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (((ModifedToBeTameable)this.tamable).isStayingStill()) {
            return false;
        }
        return !(this.tamable.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.m_21439_(BlockPathTypes.WATER);
        this.tamable.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.tamable.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        if (TameableUtils.hasEnchant((LivingEntity)this.tamable, DIEnchantmentRegistry.AMPHIBIOUS) && this.tamable.m_20072_() && this.tamable.m_20280_((Entity)this.owner) < 144.0) {
            this.tamable.m_21573_().m_5624_((Entity)this.owner, this.speedModifier);
        }
        this.tamable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tamable.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (!this.tamable.m_21523_() && !this.tamable.m_20159_()) {
                if (this.tamable.m_20280_((Entity)this.owner) >= 144.0) {
                    this.teleportToOwner();
                } else {
                    this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int p_25304_, int p_25305_, int p_25306_) {
        if (Math.abs((double)p_25304_ - this.owner.m_20185_()) < 2.0 && Math.abs((double)p_25306_ - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(p_25304_, p_25305_, p_25306_))) {
            return false;
        }
        this.tamable.m_7678_((double)p_25304_ + 0.5, (double)p_25305_, (double)p_25306_ + 0.5, this.tamable.m_146908_(), this.tamable.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (TameableUtils.hasEnchant((LivingEntity)this.tamable, DIEnchantmentRegistry.AMPHIBIOUS) && this.level.m_46801_(pos)) {
            return true;
        }
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.m_8055_(pos.m_7495_());
        if (!this.canFly && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_141950_((Vec3i)this.tamable.m_142538_());
        return this.level.m_45756_((Entity)this.tamable, this.tamable.m_142469_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int p_25301_, int p_25302_) {
        return this.tamable.m_21187_().nextInt(p_25302_ - p_25301_ + 1) + p_25301_;
    }
}

