/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.entity;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.github.alexthe668.domesticationinnovation.server.enchantment.DIEnchantmentRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.CommandableMob;
import com.github.alexthe668.domesticationinnovation.server.entity.DIEntityRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.HighlightedBlockEntity;
import com.github.alexthe668.domesticationinnovation.server.entity.ModifedToBeTameable;
import com.github.alexthe668.domesticationinnovation.server.misc.DIParticleRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class TameableUtils {
    private static final String ENCHANTMENT_TAG = "StoredPetEnchantments";
    private static final String COLLAR_TAG = "HasPetCollar";
    private static final String IMMUNITY_TIME_TAG = "PetImmunityTimer";
    private static final String FROZEN_TIME_TAG = "PetFrozenTime";
    private static final String ATTACK_TARGET_ENTITY = "PetAttackTarget";
    private static final String SHADOW_PUNCH_TIMES = "PetShadowPunchTimes";
    private static final String SHADOW_PUNCH_COOLDOWN = "PetShadowPunchCooldown";
    private static final String PSYCHIC_WALL_COOLDOWN = "PetPsychicWallCooldown";
    private static final String INTIMIDATION_COOLDOWN = "PetIntimidationCooldown";
    private static final String SHADOW_PUNCH_STRIKING = "PetShadowPunchStriking";
    private static final String JUKEBOX_FOLLOWER_UUID = "PetJukeboxFollowerUUID";
    private static final String JUKEBOX_FOLLOWER_DISC = "PetJukeboxFollowerDisc";
    private static final String HAS_PET_BED = "HasPetBed";
    private static final String PET_BED_X = "PetBedX";
    private static final String PET_BED_Y = "PetBedY";
    private static final String PET_BED_Z = "PetBedZ";
    private static final String PET_BED_DIMENSION = "PetBedDimension";
    private static final String FALL_DISTANCE_SYNC = "SyncedFallDistance";
    private static final String ZOMBIE_PET = "ZombiePet";
    private static final String SAFE_PET_HEALTH = "SafePetHealth";
    private static final UUID HEALTH_BOOST_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B166EEEEE");
    private static final UUID SPEED_BOOST_UUID = UUID.fromString("ff465ded-9040-4eb5-93a1-7bbe97c31744");
    private static final ResourceLocation INFAMY_ENCHANT_ATTRACTS = new ResourceLocation("domesticationinnovation:infamy_target_attracted");

    public static boolean hasSameOwnerAs(LivingEntity tameable, Entity target) {
        return TameableUtils.hasSameOwnerAsOneWay((Entity)tameable, target) || TameableUtils.hasSameOwnerAsOneWay(target, (Entity)tameable);
    }

    private static boolean hasSameOwnerAsOneWay(Entity tameable, Entity target) {
        ModifedToBeTameable axolotl;
        TamableAnimal tamed;
        if (tameable instanceof TamableAnimal && (tamed = (TamableAnimal)tameable).m_142480_() != null) {
            TamableAnimal otherPet;
            ModifedToBeTameable axolotl2;
            if (target instanceof ModifedToBeTameable && (axolotl2 = (ModifedToBeTameable)target).getTameOwner() != null && tamed.m_142480_().equals((Object)axolotl2.getTameOwner())) {
                return true;
            }
            if (target instanceof TamableAnimal && (otherPet = (TamableAnimal)target).m_142480_() != null && tamed.m_142480_().equals((Object)otherPet.m_142480_())) {
                return true;
            }
            return tamed.m_142480_().equals((Object)target);
        }
        if (tameable instanceof ModifedToBeTameable && (axolotl = (ModifedToBeTameable)tameable).getTameOwner() != null) {
            ModifedToBeTameable otherPet;
            TamableAnimal tamed2;
            if (tameable instanceof TamableAnimal && (tamed2 = (TamableAnimal)tameable).m_142480_() != null && tamed2.m_142480_().equals((Object)axolotl.getTameOwner())) {
                return true;
            }
            if (target instanceof ModifedToBeTameable && (otherPet = (ModifedToBeTameable)target).getTameOwner() != null && axolotl.getTameOwner().equals((Object)otherPet.getTameOwner())) {
                return true;
            }
            return axolotl.getTameOwner().equals((Object)target);
        }
        return false;
    }

    public static boolean isPetOf(Player player, Entity entity) {
        return entity != null && (entity.m_7307_((Entity)player) || TameableUtils.hasSameOwnerAsOneWay(entity, (Entity)player));
    }

    public static boolean isTamed(Entity entity) {
        if (entity instanceof Axolotl) {
            return ((ModifedToBeTameable)entity).isTame() && (Boolean)DomesticationMod.CONFIG.tameableAxolotl.get() != false;
        }
        if (entity instanceof Fox) {
            return ((ModifedToBeTameable)entity).isTame() && (Boolean)DomesticationMod.CONFIG.tameableFox.get() != false;
        }
        if (entity instanceof Rabbit) {
            return ((ModifedToBeTameable)entity).isTame() && (Boolean)DomesticationMod.CONFIG.tameableRabbit.get() != false;
        }
        return entity instanceof ModifedToBeTameable && ((ModifedToBeTameable)entity).isTame() || entity instanceof TamableAnimal && ((TamableAnimal)entity).m_21824_();
    }

    public static boolean couldBeTamed(Entity entity) {
        return entity instanceof ModifedToBeTameable || entity instanceof TamableAnimal;
    }

    public static Entity getOwnerOf(Entity entity) {
        if (entity instanceof ModifedToBeTameable) {
            return ((ModifedToBeTameable)entity).getTameOwner();
        }
        if (entity instanceof TamableAnimal) {
            return ((TamableAnimal)entity).m_142480_();
        }
        return null;
    }

    public static UUID getOwnerUUIDOf(Entity entity) {
        if (entity instanceof ModifedToBeTameable) {
            return ((ModifedToBeTameable)entity).getTameOwnerUUID();
        }
        if (entity instanceof TamableAnimal) {
            return ((TamableAnimal)entity).m_142504_();
        }
        return null;
    }

    public static void setOwnerUUIDOf(Entity entity, UUID uuid) {
        if (entity instanceof ModifedToBeTameable) {
            ((ModifedToBeTameable)entity).setTameOwnerUUID(uuid);
        }
        if (entity instanceof TamableAnimal) {
            ((TamableAnimal)entity).m_21816_(uuid);
        }
    }

    private static void setEnchantmentTag(LivingEntity enchanted, ListTag enchants) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        Map<ResourceLocation, Integer> prevEnchants = TameableUtils.getEnchants(enchanted);
        tag.m_128365_(ENCHANTMENT_TAG, (Tag)enchants);
        TameableUtils.sync(enchanted, tag);
        TameableUtils.onUpdateEnchants(prevEnchants, enchanted);
    }

    private static void onUpdateEnchants(@Nullable Map<ResourceLocation, Integer> prevEnchants, LivingEntity enchanted) {
        AttributeModifier attributemodifier;
        int healthExtra = TameableUtils.getEnchantLevel(enchanted, DIEnchantmentRegistry.HEALTH_BOOST);
        int speedExtra = TameableUtils.getEnchantLevel(enchanted, DIEnchantmentRegistry.SPEEDSTER);
        AttributeInstance health = enchanted.m_21051_(Attributes.f_22276_);
        AttributeInstance speed = enchanted.m_21051_(Attributes.f_22279_);
        if (TameableUtils.hasEnchant(enchanted, DIEnchantmentRegistry.IMMATURITY_CURSE) || prevEnchants != null && prevEnchants.keySet().contains(DIEnchantmentRegistry.IMMATURITY_CURSE.getRegistryName())) {
            enchanted.m_20124_(Pose.FALL_FLYING);
            enchanted.m_6210_();
        }
        if (health != null) {
            if (healthExtra > 0) {
                attributemodifier = new AttributeModifier(HEALTH_BOOST_UUID, "health boost pet upgrade", (double)(healthExtra * 10), AttributeModifier.Operation.ADDITION);
                if (health.m_22109_(attributemodifier)) {
                    health.m_22130_(attributemodifier);
                    health.m_22125_(attributemodifier);
                } else {
                    health.m_22125_(attributemodifier);
                }
            } else {
                health.m_22127_(HEALTH_BOOST_UUID);
            }
        }
        if (speed != null) {
            if (speedExtra > 0) {
                attributemodifier = new AttributeModifier(SPEED_BOOST_UUID, "speedster pet upgrade", (double)((float)speedExtra * 0.075f), AttributeModifier.Operation.ADDITION);
                if (speed.m_22109_(attributemodifier)) {
                    speed.m_22130_(attributemodifier);
                    speed.m_22125_(attributemodifier);
                } else {
                    speed.m_22125_(attributemodifier);
                }
            } else {
                speed.m_22127_(SPEED_BOOST_UUID);
            }
        }
    }

    @Nullable
    private static ListTag getEnchantmentList(LivingEntity entity) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        if (tag.m_128441_(ENCHANTMENT_TAG)) {
            return tag.m_128437_(ENCHANTMENT_TAG, 10);
        }
        return null;
    }

    public static int getEnchantLevel(LivingEntity entity, Enchantment enchantment) {
        ListTag listtag = TameableUtils.getEnchantmentList(entity);
        if (listtag != null && DomesticationMod.CONFIG.isEnchantEnabled(enchantment)) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                ResourceLocation res = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
                if (res == null || !res.equals((Object)enchantment.getRegistryName())) continue;
                return EnchantmentHelper.m_182438_((CompoundTag)compoundtag);
            }
        }
        return 0;
    }

    public static boolean hasEnchant(LivingEntity entity, Enchantment enchantment) {
        return TameableUtils.getEnchantLevel(entity, enchantment) > 0;
    }

    @Nullable
    public static Map<ResourceLocation, Integer> getEnchants(LivingEntity entity) {
        ListTag listtag = TameableUtils.getEnchantmentList(entity);
        if (listtag == null) {
            return null;
        }
        HashMap<ResourceLocation, Integer> enchants = new HashMap<ResourceLocation, Integer>();
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            ResourceLocation res = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
            if (!DomesticationMod.CONFIG.isEnchantEnabled(res)) continue;
            enchants.put(res, EnchantmentHelper.m_182438_((CompoundTag)compoundtag));
        }
        return enchants;
    }

    public static List<Component> getEnchantDescriptions(LivingEntity entity) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)new TextComponent("   ").m_7220_((Component)new TranslatableComponent("message.domesticationinnovation.enchantments").m_130940_(ChatFormatting.GOLD)));
        Map<ResourceLocation, Integer> map = TameableUtils.getEnchants(entity);
        if (map != null) {
            for (Map.Entry<ResourceLocation, Integer> entry : map.entrySet()) {
                boolean isCurse = entry.getKey().m_135815_().contains("curse");
                list.add((Component)new TranslatableComponent("enchantment." + entry.getKey().m_135827_() + "." + entry.getKey().m_135815_()).m_7220_((Component)new TextComponent(" ")).m_7220_((Component)new TranslatableComponent("enchantment.level." + entry.getValue())).m_130940_(isCurse ? ChatFormatting.RED : ChatFormatting.AQUA));
            }
        }
        return list;
    }

    public static boolean hasAnyEnchants(LivingEntity entity) {
        ListTag listtag = TameableUtils.getEnchantmentList(entity);
        return listtag != null && !listtag.isEmpty();
    }

    public static void addEnchant(LivingEntity entity, EnchantmentInstance enchantment) {
        ListTag listtag = TameableUtils.getEnchantmentList(entity);
        if (listtag != null && DomesticationMod.CONFIG.isEnchantEnabled(enchantment.f_44947_)) {
            ResourceLocation resourcelocation = EnchantmentHelper.m_182432_((Enchantment)enchantment.f_44947_);
            boolean flag = true;
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                ResourceLocation resourcelocation1 = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
                if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
                if (EnchantmentHelper.m_182438_((CompoundTag)compoundtag) < enchantment.f_44948_) {
                    EnchantmentHelper.m_182440_((CompoundTag)compoundtag, (int)enchantment.f_44948_);
                }
                flag = false;
                break;
            }
            if (flag) {
                listtag.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)resourcelocation, (int)enchantment.f_44948_));
            }
            TameableUtils.setEnchantmentTag(entity, listtag);
        }
    }

    public static void clearEnchants(LivingEntity entity) {
        TameableUtils.setEnchantmentTag(entity, new ListTag());
    }

    public static void setHasCollar(LivingEntity enchanted, boolean collar) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128379_(COLLAR_TAG, collar);
        TameableUtils.sync(enchanted, tag);
    }

    public static boolean hasCollar(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128441_(COLLAR_TAG) && tag.m_128471_(COLLAR_TAG);
    }

    public static int getImmuneTime(LivingEntity enchanted) {
        if (TameableUtils.hasEnchant(enchanted, DIEnchantmentRegistry.IMMUNITY_FRAME)) {
            CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
            return tag.m_128451_(IMMUNITY_TIME_TAG);
        }
        return 0;
    }

    public static void setImmuneTime(LivingEntity enchanted, int time) {
        if (TameableUtils.hasEnchant(enchanted, DIEnchantmentRegistry.IMMUNITY_FRAME)) {
            CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
            tag.m_128405_(IMMUNITY_TIME_TAG, time);
            TameableUtils.sync(enchanted, tag);
        }
    }

    public static int getFrozenTime(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128451_(FROZEN_TIME_TAG);
    }

    public static void setFrozenTimeTag(LivingEntity enchanted, int time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128405_(FROZEN_TIME_TAG, time);
        TameableUtils.sync(enchanted, tag);
    }

    public static int getPetAttackTargetID(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return !tag.m_128441_(ATTACK_TARGET_ENTITY) ? -1 : tag.m_128451_(ATTACK_TARGET_ENTITY);
    }

    @Nullable
    public static Entity getPetAttackTarget(LivingEntity enchanted) {
        int i = TameableUtils.getPetAttackTargetID(enchanted);
        return i == -1 ? null : enchanted.f_19853_.m_6815_(i);
    }

    public static void setPetAttackTarget(LivingEntity enchanted, int id) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128405_(ATTACK_TARGET_ENTITY, id);
        TameableUtils.sync(enchanted, tag);
    }

    public static int getShadowPunchCooldown(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128451_(SHADOW_PUNCH_COOLDOWN);
    }

    public static void setShadowPunchCooldown(LivingEntity enchanted, int time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128405_(SHADOW_PUNCH_COOLDOWN, time);
        TameableUtils.sync(enchanted, tag);
    }

    public static int[] getShadowPunchTimes(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128465_(SHADOW_PUNCH_TIMES);
    }

    public static void setShadowPunchTimes(LivingEntity enchanted, int[] times) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128385_(SHADOW_PUNCH_TIMES, times);
        TameableUtils.sync(enchanted, tag);
    }

    public static void setShadowPunchStriking(LivingEntity enchanted, int[] times) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128385_(SHADOW_PUNCH_STRIKING, times);
        TameableUtils.sync(enchanted, tag);
    }

    public static int[] getShadowPunchStriking(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128465_(SHADOW_PUNCH_STRIKING);
    }

    public static void setPetJukeboxUUID(LivingEntity enchanted, UUID id) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128362_(JUKEBOX_FOLLOWER_UUID, id);
        TameableUtils.sync(enchanted, tag);
    }

    public static UUID getPetJukeboxUUID(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128441_(JUKEBOX_FOLLOWER_UUID) ? tag.m_128342_(JUKEBOX_FOLLOWER_UUID) : null;
    }

    public static void setPetJukeboxDisc(LivingEntity enchanted, ItemStack stack) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128365_(JUKEBOX_FOLLOWER_DISC, (Tag)stack.m_41739_(new CompoundTag()));
        TameableUtils.sync(enchanted, tag);
    }

    public static ItemStack getPetJukeboxDisc(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128441_(JUKEBOX_FOLLOWER_DISC) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(JUKEBOX_FOLLOWER_DISC)) : ItemStack.f_41583_;
    }

    public static int getPsychicWallCooldown(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128451_(PSYCHIC_WALL_COOLDOWN);
    }

    public static void setPsychicWallCooldown(LivingEntity enchanted, int time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128405_(PSYCHIC_WALL_COOLDOWN, time);
        TameableUtils.sync(enchanted, tag);
    }

    public static int getIntimidationCooldown(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128451_(INTIMIDATION_COOLDOWN);
    }

    public static void setIntimidationCooldown(LivingEntity enchanted, int time) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128405_(INTIMIDATION_COOLDOWN, time);
        TameableUtils.sync(enchanted, tag);
    }

    private static void sync(LivingEntity enchanted, CompoundTag tag) {
        CitadelEntityData.setCitadelTag((LivingEntity)enchanted, (CompoundTag)tag);
        if (!enchanted.f_19853_.f_46443_) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelTagUpdate", tag, enchanted.m_142049_()));
        } else {
            Citadel.sendMSGToServer((Object)new PropertiesMessage("CitadelTagUpdate", tag, enchanted.m_142049_()));
        }
    }

    @Nullable
    public static BlockPos getPetBedPos(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        if (tag.m_128471_(HAS_PET_BED) && tag.m_128441_(PET_BED_X) && tag.m_128441_(PET_BED_Y) && tag.m_128441_(PET_BED_Z)) {
            return new BlockPos(tag.m_128451_(PET_BED_X), tag.m_128451_(PET_BED_Y), tag.m_128451_(PET_BED_Z));
        }
        return null;
    }

    public static void setPetBedPos(LivingEntity enchanted, BlockPos petBed) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128379_(HAS_PET_BED, true);
        tag.m_128405_(PET_BED_X, petBed.m_123341_());
        tag.m_128405_(PET_BED_Y, petBed.m_123342_());
        tag.m_128405_(PET_BED_Z, petBed.m_123343_());
        TameableUtils.sync(enchanted, tag);
    }

    public static void removePetBedPos(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128379_(HAS_PET_BED, false);
        TameableUtils.sync(enchanted, tag);
    }

    public static String getPetBedDimension(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return !tag.m_128441_(PET_BED_DIMENSION) ? "minecraft:overworld" : tag.m_128461_(PET_BED_DIMENSION);
    }

    public static void setPetBedDimension(LivingEntity enchanted, String dimension) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128359_(PET_BED_DIMENSION, dimension);
        TameableUtils.sync(enchanted, tag);
    }

    public static double getSafePetHealth(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128459_(SAFE_PET_HEALTH);
    }

    public static void setSafePetHealth(LivingEntity enchanted, double health) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128347_(SAFE_PET_HEALTH, health);
        TameableUtils.sync(enchanted, tag);
    }

    public static void attractAnimals(LivingEntity attractor, int max) {
        if ((attractor.f_19797_ + attractor.m_142049_()) % 8 == 0) {
            Predicate<Entity> notOnTeam = animal -> !TameableUtils.hasSameOwnerAs((LivingEntity)animal, (Entity)attractor) && animal.m_20270_((Entity)attractor) > 3.0f + attractor.m_20205_() * 1.6f;
            List list = attractor.f_19853_.m_6443_(Animal.class, attractor.m_142469_().m_82377_(16.0, 8.0, 16.0), EntitySelector.f_20408_.and(notOnTeam));
            list.sort(Comparator.comparingDouble(arg_0 -> ((LivingEntity)attractor).m_20280_(arg_0)));
            for (int i = 0; i < Math.min(max, list.size()); ++i) {
                Animal e = (Animal)list.get(i);
                e.m_6710_(null);
                e.m_6703_(null);
                e.m_21573_().m_5624_((Entity)attractor, 1.1);
            }
        }
    }

    public static void aggroRandomMonsters(LivingEntity attractor) {
        if ((attractor.f_19797_ + attractor.m_142049_()) % 400 == 0) {
            Predicate<Entity> notOnTeamAndMonster = animal -> animal instanceof Monster && !TameableUtils.hasSameOwnerAs((LivingEntity)animal, (Entity)attractor) && animal.m_20270_((Entity)attractor) > 3.0f + attractor.m_20205_() * 1.6f;
            List list = attractor.f_19853_.m_6443_(Mob.class, attractor.m_142469_().m_82377_(20.0, 8.0, 20.0), EntitySelector.f_20408_.and(notOnTeamAndMonster));
            list.sort(Comparator.comparingDouble(arg_0 -> ((LivingEntity)attractor).m_20280_(arg_0)));
            if (!list.isEmpty()) {
                ((Mob)list.get(0)).m_6710_(attractor);
            }
        }
    }

    public static void scareRandomMonsters(LivingEntity scary, int level) {
        boolean interval;
        boolean bl = interval = (scary.f_19797_ + scary.m_142049_()) % Math.max(140, 600 - level * 200) == 0;
        if (interval || scary.f_20916_ == 4 || TameableUtils.getIntimidationCooldown(scary) > 0) {
            Predicate<Entity> notOnTeamAndMonster = animal -> animal instanceof Monster && !TameableUtils.hasSameOwnerAs((LivingEntity)animal, (Entity)scary) && animal.m_20270_((Entity)scary) > 3.0f + scary.m_20205_() * 1.6f;
            List list = scary.f_19853_.m_6443_(PathfinderMob.class, scary.m_142469_().m_82377_((double)(10 * level), (double)(8 * level), (double)(10 * level)), EntitySelector.f_20408_.and(notOnTeamAndMonster));
            list.sort(Comparator.comparingDouble(arg_0 -> ((LivingEntity)scary).m_20280_(arg_0)));
            if (!list.isEmpty()) {
                if (TameableUtils.getIntimidationCooldown(scary) > 0 && !interval) {
                    TameableUtils.setIntimidationCooldown(scary, TameableUtils.getIntimidationCooldown(scary) - 1);
                } else {
                    Vec3 rots = ((PathfinderMob)list.get(0)).m_146892_().m_82546_(scary.m_146892_()).m_82541_();
                    float f = Mth.m_14116_((float)((float)(rots.f_82479_ * rots.f_82479_ + rots.f_82481_ * rots.f_82481_)));
                    double yRot = Math.atan2(-rots.f_82481_, -rots.f_82479_) * 57.2957763671875 + 90.0;
                    double xRot = Math.atan2(-rots.f_82480_, f) * 57.2957763671875;
                    scary.f_19853_.m_7106_((ParticleOptions)DIParticleRegistry.INTIMIDATION, scary.m_20185_(), scary.m_20186_(), scary.m_20189_(), (double)scary.m_142049_(), xRot, yRot);
                    TameableUtils.setIntimidationCooldown(scary, 70 * level);
                    if (scary instanceof Mob) {
                        ((Mob)scary).m_8032_();
                    }
                }
                for (PathfinderMob monster : list) {
                    Vec3 vec = LandRandomPos.m_148521_((PathfinderMob)monster, (int)(11 * level), (int)7, (Vec3)scary.m_20182_());
                    if (vec == null) continue;
                    monster.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.5);
                }
            }
        }
    }

    public static void detectRandomOres(LivingEntity attractor, int interval, int range, int effectLength, int maxOres) {
        int tick = (attractor.f_19797_ + attractor.m_142049_()) % interval;
        if (tick <= 30) {
            attractor.f_19860_ = attractor.m_146909_();
            attractor.m_146926_((float)Math.sin((float)tick * 0.6f) * 30.0f);
            Vec3 look = attractor.m_146892_().m_82549_(attractor.m_20252_(1.0f).m_82490_((double)attractor.m_20205_()));
            Random rand = attractor.m_21187_();
            for (int i = 0; i < 3; ++i) {
                double x = attractor.m_20208_(2.0);
                double y = attractor.m_20182_().f_82480_;
                double z = attractor.m_20262_(2.0);
                attractor.m_183503_().m_7106_((ParticleOptions)DIParticleRegistry.SNIFF, x, y, z, look.f_82479_, look.f_82480_, look.f_82481_);
            }
        }
        if (tick == 30) {
            ArrayList<BlockPos> ores = new ArrayList<BlockPos>();
            BlockPos blockpos = attractor.m_142538_();
            int half = range / 2;
            int i = 0;
            while (i <= half && i >= -half) {
                int j = 0;
                while (j <= range && j >= -range) {
                    int k = 0;
                    while (k <= range && k >= -range) {
                        BlockPos offset = blockpos.m_142082_(j, i, k);
                        BlockState state = attractor.m_183503_().m_8055_(offset);
                        if (state.m_204336_(Tags.Blocks.ORES)) {
                            if (ores.size() >= maxOres) break;
                            ores.add(offset);
                        }
                        k = (k <= 0 ? 1 : 0) - k;
                    }
                    j = (j <= 0 ? 1 : 0) - j;
                }
                i = (i <= 0 ? 1 : 0) - i;
            }
            for (BlockPos ore : ores) {
                HighlightedBlockEntity highlight = (HighlightedBlockEntity)((EntityType)DIEntityRegistry.HIGHLIGHTED_BLOCK.get()).m_20615_(attractor.f_19853_);
                highlight.m_146884_(Vec3.m_82539_((Vec3i)ore));
                highlight.setLifespan(effectLength);
                highlight.m_146926_(0.0f);
                highlight.m_146922_(0.0f);
                attractor.m_183503_().m_7967_((Entity)highlight);
            }
        }
    }

    public static void destroyRandomPlants(LivingEntity living) {
        if ((living.f_19797_ + living.m_142049_()) % 200 == 0) {
            int i;
            int range = 2;
            ArrayList<BlockPos> plants = new ArrayList<BlockPos>();
            ArrayList<BlockPos> grasses = new ArrayList<BlockPos>();
            BlockPos blockpos = living.m_142538_();
            int half = range / 2;
            Random r = living.m_21187_();
            int maxPlants = 2 + r.nextInt(2);
            int i2 = 0;
            while (i2 <= half && i2 >= -half) {
                int j = 0;
                while (j <= range && j >= -range) {
                    int k = 0;
                    while (k <= range && k >= -range) {
                        BlockPos offset = blockpos.m_142082_(j, i2, k);
                        BlockState state = living.m_183503_().m_8055_(offset);
                        if (!state.m_60795_() && r.nextInt(4) == 0) {
                            if (state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_198158_) || state.m_204336_(BlockTags.f_13073_)) {
                                plants.add(offset);
                            } else if (state.m_204336_(BlockTags.f_144274_) && !state.m_60713_(Blocks.f_50493_) && !state.m_60713_(Blocks.f_50546_) || state.m_60713_(Blocks.f_50093_)) {
                                grasses.add(offset);
                            }
                        }
                        k = (k <= 0 ? 1 : 0) - k;
                    }
                    j = (j <= 0 ? 1 : 0) - j;
                }
                i2 = (i2 <= 0 ? 1 : 0) - i2;
            }
            for (BlockPos plant : plants) {
                living.m_183503_().m_46597_(plant, Blocks.f_50016_.m_49966_());
                for (i = 0; i < 1 + r.nextInt(2); ++i) {
                    living.m_183503_().m_7106_((ParticleOptions)DIParticleRegistry.BLIGHT, (double)((float)plant.m_123341_() + r.nextFloat()), (double)((float)plant.m_123342_() + r.nextFloat()), (double)((float)plant.m_123343_() + r.nextFloat()), 0.0, (double)0.08f, 0.0);
                }
            }
            for (BlockPos dirt : grasses) {
                living.m_183503_().m_46597_(dirt, r.nextBoolean() ? Blocks.f_50546_.m_49966_() : Blocks.f_50493_.m_49966_());
                for (i = 0; i < 1 + r.nextInt(2); ++i) {
                    living.m_183503_().m_7106_((ParticleOptions)DIParticleRegistry.BLIGHT, (double)((float)dirt.m_123341_() + r.nextFloat()), (double)(dirt.m_123342_() + 1), (double)((float)dirt.m_123343_() + r.nextFloat()), 0.0, (double)0.08f, 0.0);
                }
            }
        }
    }

    public static float getFallDistance(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128457_(FALL_DISTANCE_SYNC);
    }

    public static void setFallDistance(LivingEntity enchanted, float dist) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128350_(FALL_DISTANCE_SYNC, dist);
        TameableUtils.sync(enchanted, tag);
    }

    public static void setZombiePet(LivingEntity enchanted, boolean zombiefied) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        tag.m_128379_(ZOMBIE_PET, zombiefied);
        TameableUtils.sync(enchanted, tag);
    }

    public static boolean isZombiePet(LivingEntity enchanted) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)enchanted);
        return tag.m_128471_(ZOMBIE_PET);
    }

    public static int getCharismaBonusForOwner(Player player) {
        Predicate<Entity> pet = animal -> TameableUtils.isTamed(animal) && TameableUtils.isPetOf(player, animal);
        List list = player.f_19853_.m_6443_(LivingEntity.class, player.m_142469_().m_82377_(25.0, 8.0, 25.0), EntitySelector.f_20408_.and(pet));
        int charismas = 0;
        for (LivingEntity entity : list) {
            charismas += 10 * TameableUtils.getEnchantLevel(entity, DIEnchantmentRegistry.CHARISMA);
        }
        return Math.min(charismas, 50);
    }

    public static boolean isValidTeleporter(LivingEntity owner, Mob animal) {
        if (TameableUtils.hasEnchant((LivingEntity)animal, DIEnchantmentRegistry.TETHERED_TELEPORT)) {
            if (animal instanceof CommandableMob) {
                CommandableMob commandableMob = (CommandableMob)animal;
                return commandableMob.getCommand() == 2;
            }
            if (animal instanceof TamableAnimal) {
                TamableAnimal tame = (TamableAnimal)animal;
                return !tame.m_21827_() && animal.m_20270_((Entity)owner) < 10.0f;
            }
        }
        return false;
    }
}

