/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server.entity;

import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.github.alexthe668.domesticationinnovation.server.enchantment.DIEnchantmentRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.DIEntityRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class FollowingJukeboxEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> FOLLOWING_UUID = SynchedEntityData.m_135353_(FollowingJukeboxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<ItemStack> JUKEBOX_ITEM = SynchedEntityData.m_135353_(FollowingJukeboxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public FollowingJukeboxEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public FollowingJukeboxEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)DIEntityRegistry.FOLLOWING_JUKEBOX.get(), world);
    }

    public void m_8119_() {
        super.m_8119_();
        Entity following = this.getFollowing();
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        this.m_146922_(this.m_146908_() + 2.0f);
        if (!this.f_19853_.f_46443_) {
            if (following != null) {
                float width = following.m_20205_() + 0.6f;
                this.setRecordItem(this.getDiscFromOwner());
                float speed = 0.05f;
                if (this.m_20270_(following) > 2.0f + width) {
                    this.m_20359_(following);
                } else {
                    double targetX = following.m_20185_() + Math.sin((float)this.f_19797_ * speed) * (double)width;
                    double targetY = following.m_20186_();
                    double targetZ = following.m_20189_() - Math.cos((float)this.f_19797_ * speed) * (double)width;
                    Vec3 vec3 = new Vec3(targetX - this.m_20185_(), targetY - this.m_20186_() + Math.sin((float)this.f_19797_ * 0.3f + 2.0f) * (double)0.01f, targetZ - this.m_20189_());
                    this.m_20256_(vec3);
                }
                if (!this.m_20067_() && !this.getRecordItem().m_41619_()) {
                    this.f_19853_.m_7605_((Entity)this, (byte)66);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)67);
                }
                if (following instanceof LivingEntity && !TameableUtils.hasEnchant((LivingEntity)following, DIEnchantmentRegistry.DISK_JOCKEY)) {
                    this.setFollowingUUID(null);
                }
            } else {
                this.setRecordItem(ItemStack.f_41583_);
                this.m_146870_();
            }
        }
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(FOLLOWING_UUID, Optional.empty());
        this.f_19804_.m_135372_(JUKEBOX_ITEM, (Object)ItemStack.f_41583_);
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("FollowerUUID")) {
            this.setFollowingUUID(tag.m_128342_("FollowerUUID"));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.getFollowerUUID() != null) {
            tag.m_128362_("FollowerUUID", this.getFollowerUUID());
        }
    }

    @Nullable
    public UUID getFollowerUUID() {
        return ((Optional)this.f_19804_.m_135370_(FOLLOWING_UUID)).orElse(null);
    }

    public void setFollowingUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(FOLLOWING_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getFollowing() {
        UUID id = this.getFollowerUUID();
        if (id != null && !this.f_19853_.f_46443_) {
            return ((ServerLevel)this.f_19853_).m_8791_(id);
        }
        return null;
    }

    public ItemStack getRecordItem() {
        return (ItemStack)this.f_19804_.m_135370_(JUKEBOX_ITEM);
    }

    public void setRecordItem(ItemStack item) {
        this.f_19804_.m_135381_(JUKEBOX_ITEM, (Object)item);
    }

    public void addDiscToOwner(ItemStack stack) {
        Entity entity = this.getFollowing();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            TameableUtils.setPetJukeboxDisc(living, stack);
            if (stack.m_41619_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)67);
            }
        }
    }

    public ItemStack getDiscFromOwner() {
        Entity entity = this.getFollowing();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return TameableUtils.getPetJukeboxDisc(living);
        }
        return ItemStack.f_41583_;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec3, InteractionHand hand) {
        return this.m_6096_(player, hand);
    }

    public boolean m_6087_() {
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        boolean flag = false;
        ItemStack held = player.m_21120_(hand);
        if (!this.getRecordItem().m_41619_()) {
            ItemStack copy = this.getRecordItem().m_41777_();
            this.addDiscToOwner(ItemStack.f_41583_);
            this.m_19983_(copy);
            flag = true;
        }
        if (held.m_41720_() instanceof RecordItem) {
            this.addDiscToOwner(held);
            if (!player.m_7500_()) {
                held.m_41774_(1);
            }
            flag = true;
        }
        return flag ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 66 || id == 67) {
            if (this.getRecordSound() != null && this.f_19796_.nextFloat() < 0.1f) {
                float f = this.f_19796_.nextFloat();
                float f1 = this.f_19796_.nextFloat();
                float f2 = this.f_19796_.nextFloat();
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), (double)f, (double)f1, (double)f2);
            }
            DomesticationMod.PROXY.updateEntityStatus(this, id);
        } else {
            super.m_7822_(id);
        }
    }

    @Nullable
    public SoundEvent getRecordSound() {
        Item item = this.getRecordItem().m_41720_();
        if (item instanceof RecordItem) {
            RecordItem record = (RecordItem)item;
            return record.m_43051_();
        }
        return null;
    }
}

