/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.server;

import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.github.alexthe668.domesticationinnovation.server.block.DIBlockRegistry;
import com.github.alexthe668.domesticationinnovation.server.block.PetBedBlock;
import com.github.alexthe668.domesticationinnovation.server.block.PetBedBlockEntity;
import com.github.alexthe668.domesticationinnovation.server.enchantment.DIEnchantmentRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.ChainLightningEntity;
import com.github.alexthe668.domesticationinnovation.server.entity.CommandableMob;
import com.github.alexthe668.domesticationinnovation.server.entity.DIEntityRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.DIVillagerRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.FollowingJukeboxEntity;
import com.github.alexthe668.domesticationinnovation.server.entity.GiantBubbleEntity;
import com.github.alexthe668.domesticationinnovation.server.entity.ModifedToBeTameable;
import com.github.alexthe668.domesticationinnovation.server.entity.PsychicWallEntity;
import com.github.alexthe668.domesticationinnovation.server.entity.RecallBallEntity;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import com.github.alexthe668.domesticationinnovation.server.item.DIItemRegistry;
import com.github.alexthe668.domesticationinnovation.server.item.DeedOfOwnershipItem;
import com.github.alexthe668.domesticationinnovation.server.misc.DIDamageTypes;
import com.github.alexthe668.domesticationinnovation.server.misc.DIParticleRegistry;
import com.github.alexthe668.domesticationinnovation.server.misc.DISoundRegistry;
import com.github.alexthe668.domesticationinnovation.server.misc.DIWorldData;
import com.github.alexthe668.domesticationinnovation.server.misc.RespawnRequest;
import com.github.alexthe668.domesticationinnovation.server.misc.trades.BuyingItemTrade;
import com.github.alexthe668.domesticationinnovation.server.misc.trades.EnchantItemTrade;
import com.github.alexthe668.domesticationinnovation.server.misc.trades.SellingEnchantedBook;
import com.github.alexthe668.domesticationinnovation.server.misc.trades.SellingItemTrade;
import com.github.alexthe668.domesticationinnovation.server.misc.trades.SellingOneOfTheseItemsTrade;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.antlr.v4.runtime.misc.Triple;

@Mod.EventBusSubscriber(modid="domesticationinnovation", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonProxy {
    private static final UUID FROST_FANG_SLOW = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4cf");
    private static final TargetingConditions ZOMBIE_TARGET = TargetingConditions.m_148352_().m_26883_(32.0);
    public static List<Triple<Entity, ServerLevel, UUID>> teleportingPets = new ArrayList<Triple<Entity, ServerLevel, UUID>>();

    public void init() {
    }

    public void clientInit() {
    }

    public void setupParticles() {
    }

    public void updateVisualDataForMob(Entity entity, int[] arr) {
    }

    public void updateEntityStatus(Entity entity, byte updateKind) {
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && TameableUtils.couldBeTamed((Entity)(living = (LivingEntity)entity)) && TameableUtils.hasEnchant(living, DIEnchantmentRegistry.HEALTH_BOOST)) {
            living.m_21153_((float)Math.max((double)living.m_21223_(), TameableUtils.getSafePetHealth(living)));
        }
    }

    @SubscribeEvent
    public void onEntityLeaveWorld(EntityLeaveWorldEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && TameableUtils.couldBeTamed((Entity)(living = (LivingEntity)entity)) && TameableUtils.hasEnchant(living, DIEnchantmentRegistry.HEALTH_BOOST)) {
            TameableUtils.setSafePetHealth(living, living.m_21223_());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.WorldTickEvent tick) {
        if (!tick.world.f_46443_ && tick.world instanceof ServerLevel) {
            for (Triple<Entity, ServerLevel, UUID> triple : teleportingPets) {
                Entity entity = (Entity)triple.a;
                ServerLevel endpointWorld = (ServerLevel)triple.b;
                UUID ownerUUID = (UUID)triple.c;
                entity.m_19877_();
                entity.f_19853_ = endpointWorld;
                Player player = endpointWorld.m_46003_(ownerUUID);
                if (player == null) continue;
                Entity teleportedEntity = entity.m_6095_().m_20615_((Level)endpointWorld);
                if (teleportedEntity != null) {
                    teleportedEntity.m_20361_(entity);
                    Vec3 toPos = player.m_20182_();
                    EntityDimensions dimensions = entity.m_6972_(entity.m_20089_());
                    AABB suffocationBox = new AABB((double)(-dimensions.f_20377_ / 2.0f), 0.0, (double)(-dimensions.f_20377_ / 2.0f), (double)(dimensions.f_20377_ / 2.0f), (double)dimensions.f_20378_, (double)(dimensions.f_20377_ / 2.0f));
                    while (!endpointWorld.m_45756_(entity, suffocationBox.m_82386_(toPos.f_82479_, toPos.f_82480_, toPos.f_82481_)) && toPos.f_82480_ < 300.0) {
                        toPos = toPos.m_82520_(0.0, 1.0, 0.0);
                    }
                    teleportedEntity.m_7678_(toPos.f_82479_, toPos.f_82480_, toPos.f_82481_, entity.m_146908_(), entity.m_146909_());
                    teleportedEntity.m_5616_(entity.m_6080_());
                    teleportedEntity.f_19789_ = 0.0f;
                    teleportedEntity.m_20091_();
                    endpointWorld.m_7967_(teleportedEntity);
                }
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            teleportingPets.clear();
        }
    }

    @SubscribeEvent
    public void onProjectileImpactEvent(ProjectileImpactEvent event) {
        if (event.getRayTraceResult() instanceof EntityHitResult) {
            Player player;
            Entity hit = ((EntityHitResult)event.getRayTraceResult()).m_82443_();
            if (event.getProjectile().m_37282_() instanceof Player && TameableUtils.isPetOf(player = (Player)event.getProjectile().m_37282_(), hit)) {
                event.setCanceled(true);
            }
            if (TameableUtils.isTamed(hit) && TameableUtils.hasEnchant((LivingEntity)hit, DIEnchantmentRegistry.DEFLECTION)) {
                AbstractArrow arrow;
                Entity entity = event.getEntity();
                if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_36796_() > 0) {
                    arrow.m_36767_((byte)0);
                    arrow.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                event.setCanceled(true);
                float xRot = event.getProjectile().m_146909_();
                float yRot = event.getProjectile().f_19859_;
                Vec3 vec3 = event.getProjectile().m_20182_().m_82546_(hit.m_20182_()).m_82541_().m_82490_((double)(hit.m_20205_() + 0.5f));
                Vec3 vec32 = hit.m_20182_().m_82549_(vec3);
                hit.f_19853_.m_7106_((ParticleOptions)DIParticleRegistry.DEFLECTION_SHIELD, vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, (double)xRot, (double)yRot, 0.0);
                event.getProjectile().m_20256_(event.getProjectile().m_20184_().m_82490_(-0.2));
                event.getProjectile().m_146922_(yRot + 180.0f);
                event.getProjectile().m_146926_(xRot + 180.0f);
            }
        }
    }

    @SubscribeEvent
    public void onItemDespawnEvent(ItemExpireEvent event) {
        if (event.getEntityItem().m_32055_().m_41720_() == Items.f_42410_ && ((Boolean)DomesticationMod.CONFIG.rottenApple.get()).booleanValue()) {
            Random random = new Random();
            if (random.nextFloat() < 0.1f * (float)event.getEntityItem().m_32055_().m_41613_()) {
                event.getEntityItem().m_32055_().m_41774_(1);
                event.setExtraLife(10);
                ItemEntity rotten = new ItemEntity(event.getEntityItem().f_19853_, event.getEntityItem().m_20185_(), event.getEntityItem().m_20186_(), event.getEntityItem().m_20189_(), new ItemStack((ItemLike)DIItemRegistry.ROTTEN_APPLE.get()));
                event.getEntityItem().m_183503_().m_7967_((Entity)rotten);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        int frozenTime = TameableUtils.getFrozenTime(event.getEntityLiving());
        if (TameableUtils.couldBeTamed((Entity)event.getEntityLiving())) {
            int psychicWallLevel;
            LivingEntity targetX2;
            int oreLvl;
            int shepherdLvl;
            LivingEntity follower2;
            UUID uuid;
            LivingEntity owner;
            Mob mob;
            LivingEntity move2;
            int shadowHandsLevel;
            LivingEntity livingEntity;
            int i;
            if (TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.IMMUNITY_FRAME) && (i = TameableUtils.getImmuneTime(event.getEntityLiving())) > 0) {
                TameableUtils.setImmuneTime(event.getEntityLiving(), i - 1);
            }
            if (event.getEntityLiving().m_21023_(MobEffects.f_19614_) && TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.POISON_RESISTANCE)) {
                event.getEntityLiving().m_21195_(MobEffects.f_19614_);
            }
            if (TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.AMPHIBIOUS)) {
                event.getEntityLiving().m_20301_(event.getEntityLiving().m_6062_());
            }
            if (TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.MAGNETIC) && (livingEntity = event.getEntityLiving()) instanceof Mob) {
                Mob mob2 = (Mob)livingEntity;
                Entity sucking = TameableUtils.getPetAttackTarget((LivingEntity)mob2);
                if (!mob2.f_19853_.f_46443_) {
                    if (mob2.m_5448_() == null || !mob2.m_5448_().m_6084_() || mob2.m_20270_((Entity)mob2.m_5448_()) < 0.5f + mob2.m_20205_() || mob2.m_20201_() instanceof GiantBubbleEntity) {
                        if (TameableUtils.getPetAttackTargetID((LivingEntity)mob2) != -1) {
                            TameableUtils.setPetAttackTarget((LivingEntity)mob2, -1);
                        }
                    } else {
                        TameableUtils.setPetAttackTarget((LivingEntity)mob2, mob2.m_5448_().m_142049_());
                    }
                } else if (sucking != null) {
                    double dist = mob2.m_20270_(sucking);
                    Vec3 start = mob2.m_20182_().m_82520_(0.0, (double)(mob2.m_20206_() * 0.5f), 0.0);
                    Vec3 end = sucking.m_20182_().m_82520_(0.0, (double)(sucking.m_20206_() * 0.5f), 0.0).m_82546_(start);
                    for (float distStep = mob2.m_20205_() + 0.8f; distStep < (float)((int)Math.ceil(dist)); distStep += 1.0f) {
                        Vec3 vec3 = start.m_82549_(end.m_82490_((double)distStep / dist));
                        float f1 = 0.5f * (mob2.m_21187_().nextFloat() - 0.5f);
                        float f2 = 0.5f * (mob2.m_21187_().nextFloat() - 0.5f);
                        float f3 = 0.5f * (mob2.m_21187_().nextFloat() - 0.5f);
                        mob2.f_19853_.m_7106_((ParticleOptions)DIParticleRegistry.MAGNET, vec3.f_82479_ + (double)f1, vec3.f_82480_ + (double)f2, vec3.f_82481_ + (double)f3, 0.0, 0.0, 0.0);
                    }
                }
                if (sucking != null) {
                    if (mob2.f_19797_ % 15 == 0) {
                        mob2.m_5496_(DISoundRegistry.MAGNET_LOOP, 1.0f, 1.0f);
                    }
                    mob2.m_20256_(mob2.m_20184_().m_82542_(0.88, 1.0, 0.88));
                    Vec3 move2 = new Vec3(mob2.m_20185_() - sucking.m_20185_(), mob2.m_20186_() - (double)sucking.m_20192_() / 2.0 - sucking.m_20186_(), mob2.m_20189_() - sucking.m_20189_());
                    sucking.m_20256_(sucking.m_20184_().m_82549_(move2.m_82541_().m_82490_(mob2.m_20096_() ? 0.15 : 0.05)));
                }
            }
            if ((shadowHandsLevel = TameableUtils.getEnchantLevel(event.getEntityLiving(), DIEnchantmentRegistry.SHADOW_HANDS)) > 0 && (move2 = event.getEntityLiving()) instanceof Mob) {
                mob = (Mob)move2;
                DomesticationMod.PROXY.updateVisualDataForMob((Entity)event.getEntityLiving(), TameableUtils.getShadowPunchTimes((LivingEntity)mob));
                if (!mob.f_19853_.f_46443_) {
                    Entity punching = TameableUtils.getPetAttackTarget((LivingEntity)mob);
                    int[] punchProgress = TameableUtils.getShadowPunchTimes((LivingEntity)mob);
                    if (punching != null && punching.m_6084_() && mob.m_142582_(punching) && mob.m_20270_(punching) < 16.0f) {
                        int[] striking = TameableUtils.getShadowPunchStriking((LivingEntity)mob);
                        if (punchProgress == null || punchProgress.length < shadowHandsLevel) {
                            int[] clean = new int[shadowHandsLevel];
                            TameableUtils.setShadowPunchTimes((LivingEntity)mob, clean);
                            TameableUtils.setShadowPunchStriking((LivingEntity)mob, clean);
                        } else {
                            int cooldown = TameableUtils.getShadowPunchCooldown((LivingEntity)mob);
                            if (cooldown <= 0) {
                                int start;
                                boolean flag = false;
                                for (int i2 = start = shadowHandsLevel == 1 ? 0 : mob.m_21187_().nextInt(shadowHandsLevel - 1); i2 < shadowHandsLevel; ++i2) {
                                    if (striking[i2] != 0) continue;
                                    striking[i2] = 1;
                                    flag = true;
                                    break;
                                }
                                if (flag) {
                                    TameableUtils.setShadowPunchCooldown((LivingEntity)mob, 5);
                                }
                            } else {
                                TameableUtils.setShadowPunchCooldown((LivingEntity)mob, cooldown - 1);
                            }
                            for (int i3 = 0; i3 < Math.min(shadowHandsLevel, Math.min(striking.length, punchProgress.length)); ++i3) {
                                if (striking[i3] != 0) {
                                    if (punchProgress[i3] < 10) {
                                        punchProgress[i3] = punchProgress[i3] + 1;
                                    } else {
                                        punching.m_6469_(DamageSource.m_19370_((LivingEntity)mob), (float)Mth.m_14045_((int)shadowHandsLevel, (int)2, (int)4));
                                        striking[i3] = 0;
                                    }
                                }
                                if (striking[i3] != 0 || punchProgress[i3] <= 0) continue;
                                punchProgress[i3] = punchProgress[i3] - 1;
                            }
                            TameableUtils.setShadowPunchStriking((LivingEntity)mob, striking);
                            TameableUtils.setShadowPunchTimes((LivingEntity)mob, punchProgress);
                        }
                    } else {
                        if (punching != null) {
                            boolean flag = true;
                            for (int i4 = 0; i4 < Math.min(shadowHandsLevel, punchProgress.length); ++i4) {
                                if (punchProgress[i4] <= 0) continue;
                                punchProgress[i4] = punchProgress[i4] - 1;
                                flag = false;
                            }
                            TameableUtils.setShadowPunchStriking((LivingEntity)mob, new int[shadowHandsLevel]);
                            TameableUtils.setShadowPunchTimes((LivingEntity)mob, punchProgress);
                            if (flag) {
                                TameableUtils.setPetAttackTarget((LivingEntity)mob, -1);
                            }
                        }
                        LivingEntity punchingTarget = null;
                        if (mob.m_5448_() != null) {
                            punchingTarget = mob.m_5448_();
                        } else {
                            Entity i3 = TameableUtils.getOwnerOf((Entity)mob);
                            if (i3 instanceof LivingEntity) {
                                owner = (LivingEntity)i3;
                                if (owner.m_142581_() != null && owner.m_142581_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob, (Entity)owner.m_142581_())) {
                                    punchingTarget = owner.m_142581_();
                                }
                                if (owner.m_21214_() != null && owner.m_21214_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob, (Entity)owner.m_21214_())) {
                                    punchingTarget = owner.m_21214_();
                                }
                            }
                        }
                        if (punchingTarget != null && punchingTarget.m_6084_()) {
                            TameableUtils.setPetAttackTarget((LivingEntity)mob, punchingTarget.m_142049_());
                        }
                    }
                }
            }
            if (!(!TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.DISK_JOCKEY) || event.getEntityLiving().f_19853_.f_46443_ || (uuid = TameableUtils.getPetJukeboxUUID(event.getEntityLiving())) != null && ((ServerLevel)event.getEntityLiving().f_19853_).m_8791_(uuid) instanceof FollowingJukeboxEntity)) {
                FollowingJukeboxEntity follower2 = (FollowingJukeboxEntity)((EntityType)DIEntityRegistry.FOLLOWING_JUKEBOX.get()).m_20615_(event.getEntityLiving().f_19853_);
                follower2.setFollowingUUID(event.getEntityLiving().m_142081_());
                follower2.m_20359_((Entity)event.getEntityLiving());
                event.getEntityLiving().f_19853_.m_7967_((Entity)follower2);
                TameableUtils.setPetJukeboxUUID(event.getEntityLiving(), follower2.m_142081_());
            }
            if (TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.LINKED_INVENTORY) && (follower2 = event.getEntityLiving()) instanceof Mob && !(mob = (Mob)follower2).m_21531_()) {
                mob.m_21553_(true);
            }
            if ((shepherdLvl = TameableUtils.getEnchantLevel(event.getEntityLiving(), DIEnchantmentRegistry.SHEPHERD)) > 0) {
                TameableUtils.attractAnimals(event.getEntityLiving(), shepherdLvl * 3);
            }
            if (TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.INFAMY_CURSE)) {
                TameableUtils.aggroRandomMonsters(event.getEntityLiving());
            }
            if (TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.INTIMIDATION)) {
                TameableUtils.scareRandomMonsters(event.getEntityLiving(), TameableUtils.getEnchantLevel(event.getEntityLiving(), DIEnchantmentRegistry.INTIMIDATION));
            }
            if (TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.BLIGHT_CURSE)) {
                TameableUtils.destroyRandomPlants(event.getEntityLiving());
            }
            if (TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.VOID_CLOUD) && !event.getEntityLiving().m_20072_() && event.getEntityLiving().f_19789_ > 3.0f && !event.getEntityLiving().m_20096_()) {
                double targetZ;
                Entity owner2 = TameableUtils.getOwnerOf((Entity)event.getEntityLiving());
                boolean shouldMoveToOwnerXZ = owner2 != null && Math.abs(owner2.m_20186_() - event.getEntityLiving().m_20186_()) < 1.0;
                double targetX2 = shouldMoveToOwnerXZ ? owner2.m_20185_() : event.getEntityLiving().m_20185_();
                double targetY = Math.max((double)((float)event.getEntityLiving().f_19853_.m_141937_() + 0.5f), owner2 == null ? 64.0 : (owner2.m_20186_() < event.getEntityLiving().m_20186_() ? owner2.m_20186_() + (double)0.6f : owner2.m_20227_(1.0) + (double)event.getEntityLiving().m_20206_()));
                if (owner2 != null && owner2.m_20201_() == event.getEntityLiving()) {
                    targetY = Math.min((double)((float)event.getEntityLiving().f_19853_.m_141937_() + 0.5f), event.getEntityLiving().m_20186_() - 0.5);
                }
                double d = targetZ = shouldMoveToOwnerXZ ? owner2.m_20189_() : event.getEntityLiving().m_20189_();
                if (event.getEntityLiving().f_19863_) {
                    event.getEntityLiving().m_6853_(true);
                    targetX2 += (double)((event.getEntityLiving().m_21187_().nextFloat() - 0.5f) * 4.0f);
                    targetZ += (double)((event.getEntityLiving().m_21187_().nextFloat() - 0.5f) * 4.0f);
                }
                Vec3 move3 = new Vec3(targetX2 - event.getEntityLiving().m_20185_(), targetY - event.getEntityLiving().m_20186_(), targetZ - event.getEntityLiving().m_20189_());
                event.getEntityLiving().m_20256_(event.getEntityLiving().m_20184_().m_82549_(move3.m_82541_().m_82490_(0.15)).m_82542_(0.5, 0.5, 0.5));
                if (event.getEntityLiving().f_19853_ instanceof ServerLevel) {
                    TameableUtils.setFallDistance(event.getEntityLiving(), event.getEntityLiving().f_19789_);
                    ((ServerLevel)event.getEntityLiving().f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123789_, event.getEntityLiving().m_20208_(1.5), event.getEntityLiving().m_20186_() - (double)event.getEntityLiving().m_21187_().nextFloat(), event.getEntityLiving().m_20262_(1.5), 0, 0.0, (double)-0.2f, 0.0, 1.0);
                }
            }
            if ((oreLvl = TameableUtils.getEnchantLevel(event.getEntityLiving(), DIEnchantmentRegistry.ORE_SCENTING)) > 0) {
                int interval = 100 + Math.max(150, 550 - oreLvl * 100);
                TameableUtils.detectRandomOres(event.getEntityLiving(), interval, 5 + oreLvl * 2, oreLvl * 50, oreLvl * 3);
            }
            if (TameableUtils.isZombiePet(event.getEntityLiving()) && !event.getEntityLiving().f_19853_.f_46443_ && (targetX2 = event.getEntityLiving()) instanceof Mob) {
                Mob mob3 = (Mob)targetX2;
                if (mob3.m_5448_() instanceof Player && ((Player)mob3.m_5448_()).m_7500_()) {
                    mob3.m_6710_(null);
                }
                if (mob3.m_5448_() == null || !mob3.m_5448_().m_6084_()) {
                    mob3.m_6710_((LivingEntity)mob3.f_19853_.m_45946_(ZOMBIE_TARGET, (LivingEntity)mob3));
                } else if (mob3.m_20270_((Entity)mob3.m_5448_()) < mob3.m_20205_() + 0.5f) {
                    mob3.m_7327_((Entity)mob3.m_5448_());
                } else if (mob3.m_21573_().m_26571_()) {
                    mob3.m_21573_().m_5624_((Entity)mob3.m_5448_(), 1.0);
                }
            }
            if ((psychicWallLevel = TameableUtils.getEnchantLevel(event.getEntityLiving(), DIEnchantmentRegistry.PSYCHIC_WALL)) > 0 && (owner = event.getEntityLiving()) instanceof Mob) {
                Mob mob4 = (Mob)owner;
                int cooldown = TameableUtils.getPsychicWallCooldown((LivingEntity)mob4);
                if (cooldown > 0) {
                    TameableUtils.setPsychicWallCooldown((LivingEntity)mob4, cooldown - 1);
                } else {
                    LivingEntity blocking = null;
                    Mob blockingFrom = null;
                    if (mob4.m_5448_() != null) {
                        blocking = mob4.m_5448_();
                        blockingFrom = mob4;
                    } else {
                        Entity f2 = TameableUtils.getOwnerOf((Entity)mob4);
                        if (f2 instanceof LivingEntity) {
                            LivingEntity owner3 = (LivingEntity)f2;
                            if (owner3.m_142581_() != null && owner3.m_142581_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob4, (Entity)owner3.m_142581_())) {
                                blocking = owner3.m_142581_();
                                blockingFrom = owner3;
                            }
                            if (owner3.m_21214_() != null && owner3.m_21214_().m_6084_() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob4, (Entity)owner3.m_21214_())) {
                                blocking = owner3.m_21214_();
                                blockingFrom = owner3;
                            }
                        }
                    }
                    if (blocking != null) {
                        int width = psychicWallLevel + 1;
                        float yAdditional = blocking.m_20206_() * 0.5f + (float)width * 0.5f;
                        Vec3 vec3 = blockingFrom.m_20182_().m_82520_(0.0, (double)yAdditional, 0.0);
                        Vec3 vec32 = blocking.m_20182_().m_82520_(0.0, (double)yAdditional, 0.0);
                        Vec3 vec33 = vec3.m_82549_(vec32);
                        Vec3 avg = new Vec3(vec33.f_82479_ / 2.0, Math.floor(vec33.f_82480_ / 2.0), vec33.f_82481_ / 2.0);
                        Vec3 rotationFrom = avg.m_82546_(vec3);
                        Direction dir = Direction.m_122366_((double)rotationFrom.f_82479_, (double)rotationFrom.f_82480_, (double)rotationFrom.f_82481_);
                        PsychicWallEntity wall = (PsychicWallEntity)((EntityType)DIEntityRegistry.PSYCHIC_WALL.get()).m_20615_(mob4.f_19853_);
                        wall.m_6034_(avg.f_82479_, avg.f_82480_, avg.f_82481_);
                        wall.setBlockWidth(width);
                        wall.setCreatorId(mob4.m_142081_());
                        wall.setLifespan(psychicWallLevel * 100);
                        wall.setWallDirection(dir);
                        mob4.f_19853_.m_7967_((Entity)wall);
                        TameableUtils.setPsychicWallCooldown((LivingEntity)mob4, psychicWallLevel * 200 + 40);
                    }
                }
            }
        }
        if (frozenTime > 0) {
            TameableUtils.setFrozenTimeTag(event.getEntityLiving(), frozenTime - 1);
            AttributeInstance instance = event.getEntityLiving().m_21051_(Attributes.f_22279_);
            if (instance != null) {
                float f = -0.1f * event.getEntityLiving().m_146889_();
                if (frozenTime > 1) {
                    AttributeModifier fangModifier = new AttributeModifier(FROST_FANG_SLOW, "Frost fang slow", (double)f, AttributeModifier.Operation.ADDITION);
                    if (!instance.m_22109_(fangModifier)) {
                        instance.m_22118_(fangModifier);
                    }
                } else {
                    instance.m_22120_(FROST_FANG_SLOW);
                }
            }
            for (int i = 0; i < 1 + event.getEntityLiving().m_21187_().nextInt(2); ++i) {
                event.getEntityLiving().f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175821_, event.getEntityLiving().m_20208_((double)0.7f), event.getEntityLiving().m_20187_(), event.getEntityLiving().m_20262_((double)0.7f), 0.0, 0.0, 0.0);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingAttackEvent event) {
        if (TameableUtils.isTamed((Entity)event.getEntityLiving()) && event.getSource() != DIDamageTypes.SIPHON_DAMAGE) {
            UUID owner;
            Entity owner2;
            boolean flag = false;
            if (TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.IMMUNITY_FRAME)) {
                int level = TameableUtils.getEnchantLevel(event.getEntityLiving(), DIEnchantmentRegistry.IMMUNITY_FRAME);
                if (TameableUtils.getImmuneTime(event.getEntityLiving()) <= 0) {
                    TameableUtils.setImmuneTime(event.getEntityLiving(), 20 + level * 20);
                } else {
                    flag = true;
                    event.setCanceled(true);
                }
            }
            if ((event.getSource() == DamageSource.f_19312_ || event.getSource() == DamageSource.f_19324_) && TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.AMPHIBIOUS)) {
                event.setCanceled(true);
                flag = true;
            }
            if (!flag && (event.getSource().m_146707_() || event.getSource() == DamageSource.f_19317_) && TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.VOID_CLOUD)) {
                event.setCanceled(true);
                flag = true;
            }
            if (!flag && TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.HEALTH_SIPHON) && (owner2 = TameableUtils.getOwnerOf((Entity)event.getEntityLiving())) != null && owner2.m_6084_() && owner2.m_20270_((Entity)event.getEntityLiving()) < 100.0f && owner2 != event.getEntityLiving()) {
                owner2.m_6469_(event.getSource(), event.getAmount());
                event.setCanceled(true);
                flag = true;
                event.getEntityLiving().m_6469_(DIDamageTypes.SIPHON_DAMAGE, 0.0f);
            }
            if (!flag && TameableUtils.hasEnchant(event.getEntityLiving(), DIEnchantmentRegistry.TOTAL_RECALL) && (double)(event.getEntityLiving().m_21223_() - event.getAmount()) <= 2.0 && !TameableUtils.isZombiePet(event.getEntityLiving()) && (owner = TameableUtils.getOwnerUUIDOf((Entity)event.getEntityLiving())) != null) {
                LivingEntity livingEntity = event.getEntityLiving();
                if (livingEntity instanceof Mob) {
                    Mob mob = (Mob)livingEntity;
                    mob.m_8032_();
                }
                event.getEntityLiving().m_5496_(SoundEvents.f_11888_, 1.0f, 1.5f);
                RecallBallEntity recallBall = (RecallBallEntity)((EntityType)DIEntityRegistry.RECALL_BALL.get()).m_20615_(event.getEntityLiving().f_19853_);
                recallBall.setOwnerUUID(owner);
                CompoundTag tag = new CompoundTag();
                event.getEntityLiving().m_7380_(tag);
                recallBall.setContainedData(tag);
                recallBall.setContainedEntityType(event.getEntityLiving().m_6095_().getRegistryName().toString());
                recallBall.m_20359_((Entity)event.getEntityLiving());
                recallBall.m_146922_(event.getEntityLiving().m_146908_());
                recallBall.m_20331_(true);
                event.getEntityLiving().m_8127_();
                if (event.getEntityLiving().f_19853_.m_7967_((Entity)recallBall)) {
                    event.getEntityLiving().m_146870_();
                }
                flag = true;
                event.setCanceled(true);
            }
        }
        if (event.getSource().m_7639_() != null && TameableUtils.isTamed(event.getSource().m_7639_())) {
            LivingEntity attacker = (LivingEntity)event.getSource().m_7639_();
            int lightningLevel = TameableUtils.getEnchantLevel(attacker, DIEnchantmentRegistry.CHAIN_LIGHTNING);
            int bubblingLevel = TameableUtils.getEnchantLevel(attacker, DIEnchantmentRegistry.BUBBLING);
            int vampireLevel = TameableUtils.getEnchantLevel(attacker, DIEnchantmentRegistry.VAMPIRE);
            if (lightningLevel > 0) {
                ChainLightningEntity lightning = (ChainLightningEntity)((EntityType)DIEntityRegistry.CHAIN_LIGHTNING.get()).m_20615_(event.getEntityLiving().f_19853_);
                lightning.setCreatorEntityID(attacker.m_142049_());
                lightning.setFromEntityID(attacker.m_142049_());
                lightning.setToEntityID(event.getEntityLiving().m_142049_());
                lightning.m_20359_((Entity)event.getEntityLiving());
                lightning.setChainsLeft(3 + lightningLevel * 3);
                event.getEntityLiving().f_19853_.m_7967_((Entity)lightning);
                event.getEntityLiving().m_5496_(DISoundRegistry.CHAIN_LIGHTNING, 1.0f, 1.0f);
            }
            if (TameableUtils.hasEnchant(attacker, DIEnchantmentRegistry.FROST_FANG)) {
                event.getEntityLiving().m_146917_(event.getEntityLiving().m_146891_() + 200);
                Vec3 vec3 = event.getEntityLiving().m_146892_().m_82546_(attacker.m_146892_()).m_82541_().m_82490_((double)(attacker.m_20205_() + 0.5f));
                Vec3 vec32 = attacker.m_146892_().m_82549_(vec3);
                for (int i = 0; i < 3 + attacker.m_21187_().nextInt(3); ++i) {
                    float f1 = 0.2f * (attacker.m_21187_().nextFloat() - 1.0f);
                    float f2 = 0.2f * (attacker.m_21187_().nextFloat() - 1.0f);
                    float f3 = 0.2f * (attacker.m_21187_().nextFloat() - 1.0f);
                    attacker.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175821_, vec32.f_82479_ + (double)f1, vec32.f_82480_ + (double)f2, vec32.f_82481_ + (double)f3, 0.0, 0.0, 0.0);
                }
                TameableUtils.setFrozenTimeTag(event.getEntityLiving(), 60);
            }
            if (bubblingLevel > 0 && !(event.getEntityLiving().m_20201_() instanceof GiantBubbleEntity) && (event.getEntityLiving().m_20096_() || event.getEntityLiving().m_20072_() || event.getEntityLiving().m_20077_())) {
                GiantBubbleEntity bubble = (GiantBubbleEntity)((EntityType)DIEntityRegistry.GIANT_BUBBLE.get()).m_20615_(event.getEntityLiving().f_19853_);
                bubble.m_20359_((Entity)event.getEntityLiving());
                event.getEntityLiving().m_7998_((Entity)bubble, true);
                bubble.setpopsIn(bubblingLevel * 40 + 40);
                event.getEntityLiving().f_19853_.m_7967_((Entity)bubble);
                event.getEntityLiving().m_5496_(DISoundRegistry.GIANT_BUBBLE_INFLATE, 1.0f, 1.0f);
            }
            if (vampireLevel > 0 && attacker.m_21223_() < attacker.m_21233_()) {
                float f = Mth.m_14036_((float)(event.getAmount() * (float)vampireLevel * 0.5f), (float)1.0f, (float)10.0f);
                attacker.m_5634_(f);
                if (event.getEntityLiving().f_19853_ instanceof ServerLevel) {
                    for (int i = 0; i < 5 + event.getEntityLiving().m_21187_().nextInt(3); ++i) {
                        double f1 = event.getEntityLiving().m_20208_((double)0.7f);
                        double f2 = event.getEntityLiving().m_20227_((double)(0.4f + event.getEntityLiving().m_21187_().nextFloat() * 0.2f));
                        double f3 = event.getEntityLiving().m_20262_((double)0.7f);
                        Vec3 motion = attacker.m_146892_().m_82492_(f1, f2, f3).m_82541_().m_82490_((double)0.2f);
                        ((ServerLevel)event.getEntityLiving().f_19853_).m_8767_((ParticleOptions)DIParticleRegistry.VAMPIRE, f1, f2, f3, 1, motion.f_82479_, motion.f_82480_, motion.f_82481_, (double)0.2f);
                    }
                }
            }
            if (!event.getEntityLiving().f_19853_.f_46443_ && TameableUtils.hasEnchant(attacker, DIEnchantmentRegistry.WARPING_BITE)) {
                for (int i = 0; i < 16; ++i) {
                    double d3 = event.getEntityLiving().m_20185_() + (attacker.m_21187_().nextDouble() - 0.5) * 16.0;
                    double d4 = Mth.m_14008_((double)(event.getEntityLiving().m_20186_() + (double)(attacker.m_21187_().nextInt(16) - 8)), (double)event.getEntityLiving().f_19853_.m_141937_(), (double)(event.getEntityLiving().f_19853_.m_141937_() + ((ServerLevel)event.getEntityLiving().f_19853_).m_143344_() - 1));
                    double d5 = event.getEntityLiving().m_20189_() + (attacker.m_21187_().nextDouble() - 0.5) * 16.0;
                    if (!event.getEntityLiving().m_20984_(d3, d4, d5, true)) continue;
                    SoundEvent soundevent = event.getEntityLiving() instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
                    event.getEntityLiving().m_5496_(soundevent, 1.0f, 1.0f);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        LivingEntity pet;
        if (event.getSource().m_7639_() instanceof LivingEntity && TameableUtils.isTamed(event.getSource().m_7639_()) && TameableUtils.hasEnchant(pet = (LivingEntity)event.getSource().m_7639_(), DIEnchantmentRegistry.IMMATURITY_CURSE)) {
            event.setAmount((float)Math.ceil(event.getAmount() * 0.7f));
        }
    }

    @SubscribeEvent
    public void onLivingDie(LivingDeathEvent event) {
        if (TameableUtils.isTamed((Entity)event.getEntityLiving()) && !TameableUtils.isZombiePet(event.getEntityLiving())) {
            Object saveName;
            BlockPos bedPos = TameableUtils.getPetBedPos(event.getEntityLiving());
            if (bedPos != null) {
                CompoundTag data = new CompoundTag();
                event.getEntityLiving().m_7380_(data);
                saveName = event.getEntityLiving().m_8077_() ? event.getEntityLiving().m_7770_().getString() : "";
                RespawnRequest request = new RespawnRequest(event.getEntityLiving().m_6095_().getRegistryName().toString(), TameableUtils.getPetBedDimension(event.getEntityLiving()), data, bedPos, event.getEntityLiving().f_19853_.m_8044_(), (String)saveName);
                DIWorldData worldData = DIWorldData.get(event.getEntityLiving().f_19853_);
                if (worldData != null) {
                    worldData.addRespawnRequest(request);
                }
            }
            if (!(event.getEntityLiving() instanceof TamableAnimal)) {
                Entity owner = TameableUtils.getOwnerOf((Entity)event.getEntityLiving());
                if (!event.getEntityLiving().f_19853_.f_46443_ && event.getEntityLiving().f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && owner instanceof ServerPlayer) {
                    owner.m_6352_(event.getEntityLiving().m_21231_().m_19293_(), Util.f_137441_);
                }
            }
            if ((saveName = event.getEntityLiving()) instanceof Mob) {
                Mob mob = (Mob)saveName;
                if (event.getEntityLiving().f_19853_.m_46791_() != Difficulty.PEACEFUL && TameableUtils.hasEnchant((LivingEntity)mob, DIEnchantmentRegistry.UNDEAD_CURSE)) {
                    Mob zombieCopy = (Mob)mob.m_6095_().m_20615_(mob.f_19853_);
                    int id = zombieCopy.m_142049_();
                    Entity owner = TameableUtils.getOwnerOf((Entity)mob);
                    CompoundTag livingNbt = new CompoundTag();
                    mob.m_7380_(livingNbt);
                    livingNbt.m_128359_("DeathLootTable", BuiltInLootTables.f_78712_.toString());
                    zombieCopy.m_7378_(livingNbt);
                    zombieCopy.m_20234_(id);
                    if (zombieCopy instanceof TamableAnimal) {
                        TamableAnimal tamed = (TamableAnimal)zombieCopy;
                        tamed.m_7105_(false);
                        tamed.m_21816_(null);
                        tamed.m_21839_(false);
                    }
                    if (zombieCopy instanceof ModifedToBeTameable) {
                        ModifedToBeTameable tameable = (ModifedToBeTameable)zombieCopy;
                        tameable.setTame(false);
                        tameable.setTameOwnerUUID(null);
                    }
                    if (zombieCopy instanceof CommandableMob) {
                        CommandableMob commandableMob = (CommandableMob)zombieCopy;
                        commandableMob.setCommand(0);
                    }
                    zombieCopy.m_20359_((Entity)mob);
                    zombieCopy.m_6710_((LivingEntity)(owner instanceof Player && !((Player)owner).m_7500_() ? (Player)owner : mob.f_19853_.m_45946_(ZOMBIE_TARGET, (LivingEntity)mob)));
                    mob.f_19853_.m_7967_((Entity)zombieCopy);
                    zombieCopy.m_21153_(zombieCopy.m_21233_());
                    TameableUtils.setZombiePet((LivingEntity)zombieCopy, true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        if (event.getEntityBeingMounted() instanceof GiantBubbleEntity && event.isDismounting() && event.getEntityBeingMounted().m_6084_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        Entity i3;
        LivingEntity living;
        Player player = event.getPlayer();
        Entity entity = event.getTarget();
        ItemStack stack = event.getItemStack();
        if (TameableUtils.isTamed(event.getTarget()) && event.getItemStack().m_150930_((Item)DIItemRegistry.DEED_OF_OWNERSHIP.get())) {
            CompoundTag tag = stack.m_41783_();
            boolean unbound = !DeedOfOwnershipItem.isBound(event.getItemStack());
            Entity currentOwner = TameableUtils.getOwnerOf(entity);
            if (TameableUtils.isTamed(entity) && currentOwner != null && currentOwner.equals((Object)player) && unbound) {
                CompoundTag newTag = new CompoundTag();
                newTag.m_128379_("HasBoundEntity", true);
                newTag.m_128362_("BoundEntity", entity.m_142081_());
                newTag.m_128359_("BoundEntityName", entity.m_7755_().getString());
                stack.m_41751_(newTag);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
            if (TameableUtils.isTamed(entity) && tag != null && tag.m_128471_("HasBoundEntity") && tag.m_128342_("BoundEntity") != null) {
                UUID fromItem = tag.m_128342_("BoundEntity");
                if (entity.m_142081_().equals(fromItem)) {
                    player.m_36335_().m_41524_(stack.m_41720_(), 5);
                    TameableUtils.setOwnerUUIDOf(entity, player.m_142081_());
                    player.m_5661_((Component)new TranslatableComponent("message.domesticationinnovation.set_owner", new Object[]{player.m_7755_(), entity.m_7755_()}), true);
                    if (currentOwner instanceof Player && !currentOwner.equals((Object)player)) {
                        ((Player)currentOwner).m_5661_((Component)new TranslatableComponent("message.domesticationinnovation.set_owner", new Object[]{player.m_7755_(), entity.m_7755_()}), true);
                    }
                    stack.m_41751_(new CompoundTag());
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
            }
        }
        if (TameableUtils.couldBeTamed(event.getTarget()) && TameableUtils.isZombiePet((LivingEntity)event.getTarget())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        Entity unbound = event.getTarget();
        if (unbound instanceof LivingEntity) {
            living = (LivingEntity)unbound;
            if (TameableUtils.isTamed(entity) && TameableUtils.hasEnchant(living, DIEnchantmentRegistry.GLUTTONOUS) && stack.m_41720_().m_41472_() && living.m_21223_() < living.m_21233_() && stack.m_41720_().m_41473_() != null) {
                living.m_5634_((float)Math.floor((float)stack.m_41720_().m_41473_().m_38744_() * 1.5f));
                if (!event.getPlayer().m_7500_()) {
                    stack.m_41774_(1);
                }
                living.m_5496_(living.m_21187_().nextBoolean() ? SoundEvents.f_12321_ : SoundEvents.f_11912_, 1.0f, living.m_6100_());
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
        if ((unbound = event.getTarget()) instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)unbound;
            if (((Boolean)DomesticationMod.CONFIG.tameableRabbit.get()).booleanValue()) {
                if (stack.m_41720_() == Items.f_42619_ || stack.m_41720_() == Items.f_42677_) {
                    if (TameableUtils.isTamed((Entity)rabbit) && rabbit.m_21223_() < rabbit.m_21233_()) {
                        rabbit.m_5634_(3.0f);
                        if (!event.getPlayer().m_7500_()) {
                            stack.m_41774_(1);
                        }
                        event.setCanceled(true);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        return;
                    }
                    if (!TameableUtils.isTamed((Entity)rabbit) && !rabbit.f_19853_.f_46443_) {
                        if (!event.getPlayer().m_7500_()) {
                            stack.m_41774_(1);
                        }
                        if (rabbit.m_21187_().nextInt(4) == 0) {
                            for (int i2 = 0; i2 < 3; ++i2) {
                                double d0 = rabbit.m_21187_().nextGaussian() * 0.02;
                                double d1 = rabbit.m_21187_().nextGaussian() * 0.02;
                                double d2 = rabbit.m_21187_().nextGaussian() * 0.02;
                                ((ServerLevel)rabbit.m_183503_()).m_8767_((ParticleOptions)ParticleTypes.f_123750_, rabbit.m_20208_(1.0), rabbit.m_20187_() + 0.5, rabbit.m_20262_(1.0), 3, d0, d1, d2, (double)0.02f);
                            }
                            ((ModifedToBeTameable)rabbit).setTame(true);
                            ((ModifedToBeTameable)rabbit).setTameOwnerUUID(event.getPlayer().m_142081_());
                            ((CommandableMob)rabbit).setCommand(1);
                        } else {
                            for (int i3 = 0; i3 < 3; ++i3) {
                                double d0 = rabbit.m_21187_().nextGaussian() * 0.02;
                                double d1 = rabbit.m_21187_().nextGaussian() * 0.02;
                                double d2 = rabbit.m_21187_().nextGaussian() * 0.02;
                                ((ServerLevel)rabbit.m_183503_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, rabbit.m_20208_(1.0), rabbit.m_20187_() + 0.5, rabbit.m_20262_(1.0), 3, d0, d1, d2, (double)0.02f);
                            }
                        }
                        event.setCanceled(true);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        return;
                    }
                }
                if (TameableUtils.isTamed((Entity)rabbit) && TameableUtils.isPetOf(event.getPlayer(), (Entity)rabbit)) {
                    ((CommandableMob)rabbit).playerSetCommand(event.getPlayer(), (Animal)rabbit);
                }
            }
        }
        if ((i3 = event.getTarget()) instanceof LivingEntity) {
            living = (LivingEntity)i3;
            if (TameableUtils.isPetOf(event.getPlayer(), entity) && event.getItemStack().m_150930_((Item)DIItemRegistry.COLLAR_TAG.get()) && ((Boolean)DomesticationMod.CONFIG.collarTag.get()).booleanValue()) {
                if (!event.getPlayer().f_19853_.f_46443_ && living.m_6084_()) {
                    Map itemEnchantments = EnchantmentHelper.m_44882_((ListTag)stack.m_41785_());
                    Map<ResourceLocation, Integer> entityEnchantments = TameableUtils.getEnchants(living);
                    if (stack.m_41788_() && living.m_8077_() && stack.m_41786_().equals(living.m_7770_())) {
                        boolean hasSameEnchants = itemEnchantments.isEmpty();
                        if (entityEnchantments != null) {
                            hasSameEnchants = true;
                            for (Map.Entry itemEntry : itemEnchantments.entrySet()) {
                                ResourceLocation name = ((Enchantment)itemEntry.getKey()).getRegistryName();
                                if (entityEnchantments.get(name) != null && entityEnchantments.get(name).equals(itemEntry.getValue())) continue;
                                hasSameEnchants = false;
                            }
                        }
                        if (hasSameEnchants) {
                            event.setCanceled(true);
                            event.setCancellationResult(InteractionResult.FAIL);
                            return;
                        }
                    }
                    if (stack.m_41788_()) {
                        living.m_6593_(stack.m_41786_());
                    }
                    if (!event.getPlayer().m_7500_()) {
                        stack.m_41774_(1);
                    }
                    if (TameableUtils.hasCollar(living)) {
                        ItemStack collarFrom = new ItemStack((ItemLike)DIItemRegistry.COLLAR_TAG.get());
                        if (entityEnchantments != null) {
                            collarFrom.m_41784_();
                            if (!collarFrom.m_41783_().m_128425_("Enchantments", 9)) {
                                collarFrom.m_41783_().m_128365_("Enchantments", (Tag)new ListTag());
                            }
                            ListTag listtag = collarFrom.m_41783_().m_128437_("Enchantments", 10);
                            for (Map.Entry<ResourceLocation, Integer> entry : entityEnchantments.entrySet()) {
                                listtag.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)entry.getKey(), (int)entry.getValue()));
                            }
                        } else {
                            collarFrom.m_41751_(null);
                        }
                        living.m_19983_(collarFrom);
                    }
                    living.m_5496_(DISoundRegistry.COLLAR_TAG, 1.0f, 1.0f);
                    TameableUtils.clearEnchants(living);
                    for (Map.Entry entry : itemEnchantments.entrySet()) {
                        TameableUtils.addEnchant(living, new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                    }
                    TameableUtils.setHasCollar(living, true);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool.Builder builder;
        LootPoolSingletonContainer.Builder item;
        if (event.getName().equals((Object)BuiltInLootTables.f_78689_) && (Double)DomesticationMod.CONFIG.sinisterCarrotLootChance.get() > 0.0) {
            item = LootItem.m_79579_((ItemLike)((ItemLike)DIItemRegistry.SINISTER_CARROT.get())).m_79707_(1);
            builder = new LootPool.Builder().name("di_bubbling_book").m_79076_((LootPoolEntryContainer.Builder)item).m_6509_(LootItemRandomChanceCondition.m_81927_((float)((Double)DomesticationMod.CONFIG.sinisterCarrotLootChance.get()).floatValue())).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f));
            event.getTable().addPool(builder.m_79082_());
        }
        if (event.getName().equals((Object)BuiltInLootTables.f_78692_) && DomesticationMod.CONFIG.isEnchantEnabled(DIEnchantmentRegistry.BUBBLING) && (Double)DomesticationMod.CONFIG.bubblingLootChance.get() > 0.0) {
            item = LootItem.m_79579_((ItemLike)Items.f_42517_).m_79707_(5).m_5577_((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().m_80444_((Enchantment)DIEnchantmentRegistry.BUBBLING)).m_79707_(1);
            builder = new LootPool.Builder().name("di_bubbling_book").m_79076_((LootPoolEntryContainer.Builder)item).m_6509_(LootItemRandomChanceCondition.m_81927_((float)((Double)DomesticationMod.CONFIG.bubblingLootChance.get()).floatValue())).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f));
            event.getTable().addPool(builder.m_79082_());
        }
        if (event.getName().equals((Object)BuiltInLootTables.f_78689_) && DomesticationMod.CONFIG.isEnchantEnabled(DIEnchantmentRegistry.VAMPIRE) && (Double)DomesticationMod.CONFIG.vampirismLootChance.get() > 0.0) {
            item = LootItem.m_79579_((ItemLike)Items.f_42517_).m_79707_(5).m_5577_((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().m_80444_((Enchantment)DIEnchantmentRegistry.VAMPIRE)).m_79707_(1);
            builder = new LootPool.Builder().name("di_vampire_book").m_79076_((LootPoolEntryContainer.Builder)item).m_6509_(LootItemRandomChanceCondition.m_81927_((float)((Double)DomesticationMod.CONFIG.vampirismLootChance.get()).floatValue())).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f));
            event.getTable().addPool(builder.m_79082_());
        }
        if (event.getName().equals((Object)BuiltInLootTables.f_78741_) && DomesticationMod.CONFIG.isEnchantEnabled(DIEnchantmentRegistry.VOID_CLOUD) && (Double)DomesticationMod.CONFIG.voidCloudLootChance.get() > 0.0) {
            item = LootItem.m_79579_((ItemLike)Items.f_42517_).m_79707_(5).m_5577_((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().m_80444_((Enchantment)DIEnchantmentRegistry.VOID_CLOUD)).m_79707_(1);
            builder = new LootPool.Builder().name("di_void_cloud_book").m_79076_((LootPoolEntryContainer.Builder)item).m_6509_(LootItemRandomChanceCondition.m_81927_((float)((Double)DomesticationMod.CONFIG.voidCloudLootChance.get()).floatValue())).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f));
            event.getTable().addPool(builder.m_79082_());
        }
        if (event.getName().equals((Object)BuiltInLootTables.f_78759_) && DomesticationMod.CONFIG.isEnchantEnabled(DIEnchantmentRegistry.ORE_SCENTING) && (Double)DomesticationMod.CONFIG.oreScentingLootChance.get() > 0.0) {
            item = LootItem.m_79579_((ItemLike)Items.f_42517_).m_79707_(5).m_5577_((LootItemFunction.Builder)new EnchantRandomlyFunction.Builder().m_80444_((Enchantment)DIEnchantmentRegistry.ORE_SCENTING)).m_79707_(1);
            builder = new LootPool.Builder().name("di_ore_scenting_book").m_79076_((LootPoolEntryContainer.Builder)item).m_6509_(LootItemRandomChanceCondition.m_81927_((float)((Double)DomesticationMod.CONFIG.oreScentingLootChance.get()).floatValue())).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f));
            event.getTable().addPool(builder.m_79082_());
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockEntity blockEntity;
        if (event.getState().m_60734_() instanceof PetBedBlock && (blockEntity = event.getWorld().m_7702_(event.getPos())) instanceof PetBedBlockEntity) {
            PetBedBlockEntity entity1 = (PetBedBlockEntity)blockEntity;
            entity1.removeAllRequestsFor(event.getPlayer());
            entity1.resetBedsForNearbyPets();
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(LivingSpawnEvent.SpecialSpawn event) {
        try {
            if (event.getEntity() != null && event.getEntity() instanceof Ravager && ((Boolean)DomesticationMod.CONFIG.rabbitsScareRavagers.get()).booleanValue()) {
                Ravager ravager = (Ravager)event.getEntity();
                ravager.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)ravager, Rabbit.class, 13.0f, 1.5, 2.0, EntitySelector.f_20408_));
            }
        }
        catch (Exception e) {
            DomesticationMod.LOGGER.warn("could not add ai tasks to ravager");
        }
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == DIVillagerRegistry.ANIMAL_TAMER) {
            ArrayList<Object> level1 = new ArrayList<Object>();
            ArrayList<Object> level2 = new ArrayList<Object>();
            ArrayList<Object> level3 = new ArrayList<Object>();
            ArrayList<Object> level4 = new ArrayList<Object>();
            ArrayList<Object> level5 = new ArrayList<Object>();
            level1.add(new BuyingItemTrade((ItemLike)Items.f_42528_, 10, 2, 10, 2));
            level1.add(new SellingItemTrade(Items.f_42500_, 3, 10, 6, 4));
            level1.add(new BuyingItemTrade((ItemLike)Items.f_42129_, 7, 1, 9, 1));
            level1.add(new SellingItemTrade(Items.f_42526_, 2, 7, 6, 3));
            level1.add(new SellingItemTrade(Items.f_42521_, 4, 2, 9, 3));
            level1.add(new SellingItemTrade((Item)DIItemRegistry.FEATHER_ON_A_STICK.get(), 3, 1, 2, 3));
            level2.add(new SellingItemTrade(Items.f_42459_, 2, 1, 6, 7));
            level2.add(new BuyingItemTrade((ItemLike)DIItemRegistry.COLLAR_TAG.get(), 5, 1, 12, 7));
            level2.add(new SellingItemTrade(Items.f_42410_, 4, 12, 3, 7));
            level2.add(new SellingOneOfTheseItemsTrade((ImmutableSet<ItemLike>)ImmutableSet.of((Object)((ItemLike)DIBlockRegistry.WHITE_PET_BED.get()), (Object)((ItemLike)DIBlockRegistry.ORANGE_PET_BED.get()), (Object)((ItemLike)DIBlockRegistry.MAGENTA_PET_BED.get()), (Object)((ItemLike)DIBlockRegistry.LIGHT_BLUE_PET_BED.get()), (Object)((ItemLike)DIBlockRegistry.YELLOW_PET_BED.get()), (Object)((ItemLike)DIBlockRegistry.LIME_PET_BED.get()), (Object[])new ItemLike[]{(ItemLike)DIBlockRegistry.PINK_PET_BED.get(), (ItemLike)DIBlockRegistry.GRAY_PET_BED.get(), (ItemLike)DIBlockRegistry.LIGHT_GRAY_PET_BED.get(), (ItemLike)DIBlockRegistry.CYAN_PET_BED.get(), (ItemLike)DIBlockRegistry.PURPLE_PET_BED.get(), (ItemLike)DIBlockRegistry.BLUE_PET_BED.get(), (ItemLike)DIBlockRegistry.BROWN_PET_BED.get(), (ItemLike)DIBlockRegistry.GREEN_PET_BED.get(), (ItemLike)DIBlockRegistry.RED_PET_BED.get(), (ItemLike)DIBlockRegistry.BLACK_PET_BED.get()}), 2, 1, 6, 7));
            level2.add(new SellingItemTrade((Item)DIItemRegistry.DEED_OF_OWNERSHIP.get(), 3, 1, 2, 7));
            level3.add(new SellingItemTrade((Item)DIItemRegistry.ROTTEN_APPLE.get(), 4, 1, 1, 10));
            level3.add(new SellingItemTrade(Items.f_42684_, 3, 1, 2, 10));
            level3.add(new SellingItemTrade(Items.f_42655_, 3, 2, 5, 10));
            level3.add(new SellingItemTrade(Items.f_42654_, 4, 1, 3, 11));
            level3.add(new SellingItemTrade((Block)DIBlockRegistry.DRUM.get(), 2, 3, 7, 11));
            level3.add(new EnchantItemTrade((Item)DIItemRegistry.COLLAR_TAG.get(), 20, 2, 8, 3, 10));
            level4.add(new SellingItemTrade(Items.f_42651_, 8, 1, 2, 15));
            level4.add(new SellingItemTrade(Items.f_151057_, 11, 1, 2, 15));
            level4.add(new SellingItemTrade(Items.f_42279_, 26, 1, 2, 15));
            level4.add(new EnchantItemTrade((Item)DIItemRegistry.COLLAR_TAG.get(), 40, 3, 18, 3, 15));
            level5.add(new SellingItemTrade(Items.f_42652_, 13, 1, 1, 18));
            level5.add(new SellingItemTrade(Items.f_42355_, 21, 1, 3, 18));
            level5.add(new EnchantItemTrade((Item)DIItemRegistry.COLLAR_TAG.get(), 50, 4, 38, 3, 20));
            level5.add(new SellingEnchantedBook(DIEnchantmentRegistry.CHARISMA, 3, 12, 1, 18, 0.02f));
            event.getTrades().put(1, level1);
            event.getTrades().put(2, level2);
            event.getTrades().put(3, level3);
            event.getTrades().put(4, level4);
            event.getTrades().put(5, level5);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (TameableUtils.isTamed((Entity)event.getEntityLiving()) && TameableUtils.getPetBedPos(event.getEntityLiving()) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start event) {
        float dist = 30.0f;
        Vec3 center = event.getExplosion().getPosition();
        Vec3 bottom = center.m_82520_((double)(-dist), (double)(-dist), (double)(-dist));
        Vec3 top = center.m_82520_((double)dist, (double)dist, (double)dist);
        Predicate<Entity> defusal = animal -> TameableUtils.isTamed(animal) && TameableUtils.hasEnchant((LivingEntity)animal, DIEnchantmentRegistry.DEFUSAL);
        boolean flag = false;
        for (LivingEntity defuser : event.getWorld().m_6443_(LivingEntity.class, new AABB(bottom, top), EntitySelector.f_20408_.and(defusal))) {
            float level = 10 * TameableUtils.getEnchantLevel(defuser, DIEnchantmentRegistry.DEFUSAL);
            if (!(defuser.m_20238_(center) <= (double)(level * level))) continue;
            flag = true;
            break;
        }
        if (flag) {
            event.setCanceled(true);
            float pitch = 1.5f + new Random().nextFloat();
            event.getWorld().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, pitch);
            Level level = event.getWorld();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, center.f_82479_, center.f_82480_ + 1.0, center.f_82481_, 5, 0.0, 0.0, 0.0, (double)0.2f);
                }
            }
        }
    }

    private void teleportNearbyPets(Player owner, Vec3 fromPos, Vec3 toPos, Level fromLevel, Level toLevel) {
        double dist = 20.0;
        boolean removeAndReadd = fromLevel.m_46472_() != toLevel.m_46472_();
        Predicate<Entity> enchantedPet = animal -> animal instanceof Mob && TameableUtils.isPetOf(owner, animal) && TameableUtils.isValidTeleporter((LivingEntity)owner, (Mob)animal);
        for (Mob entity : fromLevel.m_6443_(Mob.class, new AABB(fromPos.f_82479_ - dist, fromPos.f_82480_ - dist, fromPos.f_82481_ - dist, fromPos.f_82479_ + dist, fromPos.f_82480_ + dist, fromPos.f_82481_ + dist), EntitySelector.f_20408_.and(enchantedPet))) {
            if (removeAndReadd) {
                teleportingPets.add((Triple<Entity, ServerLevel, UUID>)new Triple((Object)entity, (Object)toLevel, (Object)owner.m_142081_()));
                continue;
            }
            EntityDimensions dimensions = entity.m_6972_(entity.m_20089_());
            AABB suffocationBox = new AABB((double)(-dimensions.f_20377_ / 2.0f), 0.0, (double)(-dimensions.f_20377_ / 2.0f), (double)(dimensions.f_20377_ / 2.0f), (double)dimensions.f_20378_, (double)(dimensions.f_20377_ / 2.0f));
            while (!toLevel.m_45756_((Entity)entity, suffocationBox.m_82386_(toPos.f_82479_, toPos.f_82480_, toPos.f_82481_)) && toPos.f_82480_ < 300.0) {
                toPos = toPos.m_82520_(0.0, 1.0, 0.0);
            }
            entity.f_19789_ = 0.0f;
            entity.m_20324_(toPos.f_82479_, toPos.f_82480_, toPos.f_82481_);
            entity.m_20091_();
        }
    }

    @SubscribeEvent
    public void onEntityTeleport(EntityTeleportEvent event) {
        if (event.getEntity() instanceof Player) {
            this.teleportNearbyPets((Player)event.getEntity(), event.getPrev(), event.getTarget(), event.getEntity().f_19853_, event.getEntity().f_19853_);
        }
    }

    @SubscribeEvent
    public void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Level level;
        if (!event.isCanceled() && (level = event.getEntity().f_19853_) instanceof ServerLevel) {
            MinecraftServer server;
            ServerLevel toLevel;
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.getEntity() instanceof Player && (toLevel = (server = serverLevel.m_142572_()).m_129880_(event.getDimension())) != null) {
                this.teleportNearbyPets((Player)event.getEntity(), event.getEntity().m_20182_(), event.getEntity().m_20182_(), event.getEntity().f_19853_, (Level)toLevel);
            }
        }
    }
}

