/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.mixin;

import com.github.alexthe668.domesticationinnovation.server.enchantment.DIEnchantmentRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.PsychicWallEntity;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(method={"Lnet/minecraft/world/entity/Entity;fireImmune()Z"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    private void di_isFireImmune(CallbackInfoReturnable<Boolean> cir) {
        Entity us = (Entity)this;
        if (TameableUtils.isTamed(us) && TameableUtils.hasEnchant((LivingEntity)us, DIEnchantmentRegistry.FIREPROOF)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;isPushedByFluid()Z"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    protected void di_pushedByWater(CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof LivingEntity && TameableUtils.isTamed((Entity)((LivingEntity)this)) && TameableUtils.hasEnchant((LivingEntity)this, DIEnchantmentRegistry.AMPHIBIOUS)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;isAlliedTo(Lnet/minecraft/world/entity/Entity;)Z"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    protected void di_isAlliedTo(Entity other, CallbackInfoReturnable<Boolean> cir) {
        if (TameableUtils.isTamed(other) && TameableUtils.isTamed((Entity)this) && TameableUtils.hasSameOwnerAs((LivingEntity)other, (Entity)this)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;canCollideWith(Lnet/minecraft/world/entity/Entity;)Z"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    protected void di_canCollideWith(Entity other, CallbackInfoReturnable<Boolean> cir) {
        if (other instanceof PsychicWallEntity && ((PsychicWallEntity)other).isSameTeam((Entity)this)) {
            cir.setReturnValue((Object)false);
        }
    }
}

