/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.mixin;

import com.github.alexthe668.domesticationinnovation.server.enchantment.DIEnchantmentRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.DIActivityRegistry;
import com.github.alexthe668.domesticationinnovation.server.entity.ModifedToBeTameable;
import com.github.alexthe668.domesticationinnovation.server.entity.TameableUtils;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.AxolotlFollowOwnerBehavior;
import com.github.alexthe668.domesticationinnovation.server.entity.ai.AxolotlStayBehavior;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxolotlAi.class})
public class AxolotlAiMixin {
    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;makeBrain(Lnet/minecraft/world/entity/ai/Brain;)Lnet/minecraft/world/entity/ai/Brain;"}, remap=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;initPlayDeadActivity(Lnet/minecraft/world/entity/ai/Brain;)V")})
    private static void di_makeBrain(Brain<Axolotl> brain, CallbackInfoReturnable<Brain<?>> cir) {
        brain.m_21900_(DIActivityRegistry.AXOLOTL_FOLLOW, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new AxolotlFollowOwnerBehavior())), (Object)Pair.of((Object)1, (Object)new StartAttacking(AxolotlAiMixin::findAttackTargetAxl))));
        brain.m_21900_(DIActivityRegistry.AXOLOTL_STAY, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new AxolotlStayBehavior()))));
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;updateActivity(Lnet/minecraft/world/entity/animal/axolotl/Axolotl;)V"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    private static void di_updateActivity(Axolotl axolotl, CallbackInfo ci) {
        Brain brain = axolotl.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        if (activity != Activity.f_150238_ && !axolotl.m_149175_() && axolotl instanceof ModifedToBeTameable) {
            ModifedToBeTameable modifedToBeTameable = (ModifedToBeTameable)axolotl;
            if (modifedToBeTameable.isStayingStill()) {
                brain.m_21889_(DIActivityRegistry.AXOLOTL_STAY);
                ci.cancel();
            } else if (modifedToBeTameable.isFollowingOwner()) {
                brain.m_21926_((List)ImmutableList.of((Object)Activity.f_150238_, (Object)Activity.f_37988_, (Object)DIActivityRegistry.AXOLOTL_FOLLOW));
                ci.cancel();
            }
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;getTemptations()Lnet/minecraft/world/item/crafting/Ingredient;"}, remap=true, at={@At(value="TAIL")}, cancellable=true)
    private static void di_getTemptationItems(CallbackInfoReturnable<Ingredient> cir) {
        cir.setReturnValue((Object)Ingredient.merge((Collection)ImmutableList.of((Object)((Ingredient)cir.getReturnValue()), (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42528_}))));
    }

    private static Optional<? extends LivingEntity> findAttackTargetAxl(Axolotl p_149299_) {
        return p_149299_.m_27593_() ? Optional.empty() : p_149299_.m_6274_().m_21952_(MemoryModuleType.f_148194_);
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;getSpeedModifierChasing(Lnet/minecraft/world/entity/LivingEntity;)F"}, remap=true, at={@At(value="TAIL")}, cancellable=true)
    private static void di_getSpeedModifierChasing(LivingEntity axolotl, CallbackInfoReturnable<Float> cir) {
        int speedsterLevel = TameableUtils.getEnchantLevel(axolotl, DIEnchantmentRegistry.SPEEDSTER);
        cir.setReturnValue((Object)Float.valueOf(axolotl.m_20072_() ? 0.6f + (float)speedsterLevel * 0.05f : 0.15f + (float)speedsterLevel * 0.1f));
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;getSpeedModifierFollowingAdult(Lnet/minecraft/world/entity/LivingEntity;)F"}, remap=true, at={@At(value="TAIL")}, cancellable=true)
    private static void di_getSpeedModifierFollowingAdult(LivingEntity axolotl, CallbackInfoReturnable<Float> cir) {
        int speedsterLevel = TameableUtils.getEnchantLevel(axolotl, DIEnchantmentRegistry.SPEEDSTER);
        cir.setReturnValue((Object)Float.valueOf(axolotl.m_20072_() ? 0.6f + (float)speedsterLevel * 0.05f : 0.15f + (float)speedsterLevel * 0.1f));
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;getSpeedModifier(Lnet/minecraft/world/entity/LivingEntity;)F"}, remap=true, at={@At(value="TAIL")}, cancellable=true)
    private static void di_getSpeedModifier(LivingEntity axolotl, CallbackInfoReturnable<Float> cir) {
        int speedsterLevel = TameableUtils.getEnchantLevel(axolotl, DIEnchantmentRegistry.SPEEDSTER);
        cir.setReturnValue((Object)Float.valueOf(axolotl.m_20072_() ? 0.5f + (float)speedsterLevel * 0.05f : 0.15f + (float)speedsterLevel * 0.15f));
    }
}

